/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.core.model.db.validator;

import org.apache.sentry.core.common.validator.PrivilegeValidatorContext;
import org.apache.sentry.core.model.db.DBModelAuthorizable;
import org.apache.sentry.core.model.db.Server;
import org.apache.sentry.core.model.db.validator.AbstractDBPrivilegeValidator;
import org.apache.shiro.config.ConfigurationException;

public class ServerNameMustMatch
extends AbstractDBPrivilegeValidator {
    private final String serverName;

    public ServerNameMustMatch(String serverName) {
        this.serverName = serverName;
    }

    public void validate(PrivilegeValidatorContext context) throws ConfigurationException {
        String privilege = context.getPrivilege();
        Iterable<DBModelAuthorizable> authorizables = ServerNameMustMatch.parsePrivilege(privilege);
        for (DBModelAuthorizable authorizable : authorizables) {
            if (!(authorizable instanceof Server) || this.serverName.equalsIgnoreCase(authorizable.getName())) continue;
            String msg = "Server name " + authorizable.getName() + " in " + privilege + " is invalid. Expected " + this.serverName;
            throw new ConfigurationException(msg);
        }
    }
}

