/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.codec.protobuf.jackson;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.lang.reflect.Constructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CseObjectWriter
extends ObjectWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CseObjectWriter.class);
    private static final long serialVersionUID = -6435897284942268001L;
    private static Constructor<ObjectWriter.Prefetch> prefetchConstructor = ObjectWriter.Prefetch.class.getDeclaredConstructors()[0];

    private static ObjectWriter.Prefetch createPrefetch(JsonSerializer<Object> valueSerializer) {
        try {
            return prefetchConstructor.newInstance(null, valueSerializer, null);
        }
        catch (Exception e) {
            LOGGER.error("create prefetch error:", (Throwable)e);
            return null;
        }
    }

    public CseObjectWriter(ObjectWriter base, FormatSchema schema, JsonSerializer<Object> valueSerializer) {
        super(base, base.getConfig(), new ObjectWriter.GeneratorSettings(null, schema, null, null), CseObjectWriter.createPrefetch(valueSerializer));
    }

    static {
        prefetchConstructor.setAccessible(true);
    }
}

