/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config;

import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicPropertyFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.servicecomb.config.ConfigUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class ConfigurationSpringInitializer
extends PropertyPlaceholderConfigurer
implements EnvironmentAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationSpringInitializer.class);
    public static final String EXTRA_CONFIG_SOURCE_PREFIX = "extraConfig-";

    public ConfigurationSpringInitializer() {
        this.setOrder(0x3FFFFFFF);
        this.setIgnoreUnresolvablePlaceholders(true);
    }

    public void setEnvironment(Environment environment) {
        String environmentName = this.generateNameForEnvironment(environment);
        LOGGER.info("Environment received, will get configurations from [{}].", (Object)environmentName);
        Map<String, Object> extraConfig = this.getAllProperties(environment);
        ConfigUtil.addExtraConfig(EXTRA_CONFIG_SOURCE_PREFIX + environmentName, extraConfig);
        ConfigUtil.installDynamicConfig();
    }

    protected Properties mergeProperties() throws IOException {
        Properties properties = super.mergeProperties();
        AbstractConfiguration config = ConfigurationManager.getConfigInstance();
        Iterator iter = config.getKeys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Object value = config.getProperty(key);
            properties.put(key, value);
        }
        return properties;
    }

    protected String resolvePlaceholder(String placeholder, Properties props) {
        String propertyValue = super.resolvePlaceholder(placeholder, props);
        if (propertyValue == null) {
            return DynamicPropertyFactory.getInstance().getStringProperty(placeholder, null).get();
        }
        return propertyValue;
    }

    private String generateNameForEnvironment(Environment environment) {
        String environmentName = environment.getProperty("spring.config.name");
        if (!StringUtils.isEmpty((Object)environmentName)) {
            return environmentName;
        }
        environmentName = environment.getProperty("spring.application.name");
        if (!StringUtils.isEmpty((Object)environmentName)) {
            return environmentName;
        }
        return environment.getClass().getName() + "@" + environment.hashCode();
    }

    private Map<String, Object> getAllProperties(Environment environment) {
        HashMap<String, Object> configFromSpringBoot = new HashMap<String, Object>();
        if (!(environment instanceof ConfigurableEnvironment)) {
            return configFromSpringBoot;
        }
        ConfigurableEnvironment configurableEnvironment = (ConfigurableEnvironment)environment;
        for (PropertySource propertySource : configurableEnvironment.getPropertySources()) {
            this.getProperties(configurableEnvironment, propertySource, configFromSpringBoot);
        }
        return configFromSpringBoot;
    }

    private void getProperties(ConfigurableEnvironment environment, PropertySource<?> propertySource, Map<String, Object> configFromSpringBoot) {
        if (propertySource instanceof CompositePropertySource) {
            CompositePropertySource compositePropertySource = (CompositePropertySource)propertySource;
            compositePropertySource.getPropertySources().forEach(ps -> this.getProperties(environment, (PropertySource<?>)ps, configFromSpringBoot));
            return;
        }
        if (propertySource instanceof EnumerablePropertySource) {
            EnumerablePropertySource enumerablePropertySource = (EnumerablePropertySource)propertySource;
            for (String propertyName : enumerablePropertySource.getPropertyNames()) {
                configFromSpringBoot.put(propertyName, environment.getProperty(propertyName));
            }
            return;
        }
        LOGGER.debug("a none EnumerablePropertySource is ignored, propertySourceName = [{}]", (Object)propertySource.getName());
    }
}

