/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.metrics;

import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.spectator.api.CompositeRegistry;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Meter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.foundation.metrics.MetricsBootstrapConfig;
import org.apache.servicecomb.foundation.metrics.MetricsInitializer;
import org.apache.servicecomb.foundation.metrics.PolledEvent;

public class MetricsBootstrap {
    private CompositeRegistry globalRegistry;
    private EventBus eventBus;
    private MetricsBootstrapConfig config = new MetricsBootstrapConfig();
    private ScheduledExecutorService executorService;

    public void start(CompositeRegistry globalRegistry, EventBus eventBus) {
        this.globalRegistry = globalRegistry;
        this.eventBus = eventBus;
        this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("spectator-poller-%d").build());
        this.loadMetricsInitializers();
        this.startPoll();
    }

    public void shutdown() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        ArrayList initializers = new ArrayList(SPIServiceUtils.getSortedService(MetricsInitializer.class));
        Collections.reverse(initializers);
        initializers.forEach(initializer -> initializer.destroy());
    }

    protected void loadMetricsInitializers() {
        SPIServiceUtils.getSortedService(MetricsInitializer.class).forEach(initializer -> initializer.init(this.globalRegistry, this.eventBus, this.config));
    }

    protected void startPoll() {
        this.executorService.scheduleAtFixedRate(this::pollMeters, 0L, this.config.getMsPollInterval(), TimeUnit.MILLISECONDS);
    }

    protected void pollMeters() {
        ArrayList meters = Lists.newArrayList((Iterator)this.globalRegistry.iterator());
        ArrayList<Measurement> measurements = new ArrayList<Measurement>();
        for (Meter meter : meters) {
            meter.measure().forEach(measurements::add);
        }
        PolledEvent event = new PolledEvent(meters, measurements);
        this.eventBus.post((Object)event);
    }
}

