/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.qps;

import com.netflix.config.DynamicProperty;
import java.util.Map;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.qps.QpsController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QpsControllerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(QpsControllerManager.class);
    protected final Map<String, QpsController> configQpsControllerMap = new ConcurrentHashMapEx();
    protected final Map<String, QpsController> qualifiedNameControllerMap = new ConcurrentHashMapEx();
    protected QpsController globalQpsController;
    public static final String SEPARATOR = ".";
    private String configKeyPrefix;

    public QpsController getOrCreate(String microserviceName, Invocation invocation) {
        return this.qualifiedNameControllerMap.computeIfAbsent(microserviceName + SEPARATOR + invocation.getOperationMeta().getSchemaQualifiedName(), key -> this.create((String)key, microserviceName, invocation));
    }

    protected QpsController create(String qualifiedNameKey, String microserviceName, Invocation invocation) {
        this.createQpsControllerIfNotExist(microserviceName);
        this.createQpsControllerIfNotExist(qualifiedNameKey.substring(0, microserviceName.length() + invocation.getSchemaId().length() + 1));
        this.createQpsControllerIfNotExist(qualifiedNameKey);
        return this.searchQpsController(qualifiedNameKey);
    }

    protected QpsController searchQpsController(String qualifiedNameKey) {
        QpsController qpsController = this.configQpsControllerMap.get(qualifiedNameKey);
        if (this.isValidQpsController(qpsController)) {
            return qpsController;
        }
        int index = qualifiedNameKey.lastIndexOf(SEPARATOR);
        while (index > 0) {
            qpsController = this.configQpsControllerMap.get(qualifiedNameKey.substring(0, index));
            if (this.isValidQpsController(qpsController)) {
                return qpsController;
            }
            index = qualifiedNameKey.lastIndexOf(SEPARATOR, index - 1);
        }
        if (this.isValidQpsController(qpsController)) {
            return qpsController;
        }
        if (null != this.globalQpsController) {
            return this.globalQpsController;
        }
        return qpsController;
    }

    private boolean keyMatch(String configKey, Map.Entry<String, QpsController> controllerEntry) {
        return controllerEntry.getKey().equals(configKey) || controllerEntry.getKey().startsWith(configKey + SEPARATOR);
    }

    private boolean isValidQpsController(QpsController qpsController) {
        return null != qpsController && null != qpsController.getQpsLimit();
    }

    private void createQpsControllerIfNotExist(String configKey) {
        if (this.configQpsControllerMap.keySet().contains(configKey)) {
            return;
        }
        LOGGER.info("Create qpsController, configKey = [{}]", (Object)configKey);
        DynamicProperty property = this.getDynamicProperty(configKey);
        QpsController qpsController = new QpsController(configKey, property.getInteger());
        this.configQpsControllerMap.put(configKey, qpsController);
        property.addCallback(() -> {
            qpsController.setQpsLimit(property.getInteger());
            LOGGER.info("Qps limit updated, configKey = [{}], value = [{}]", (Object)configKey, (Object)property.getString());
            this.updateObjMap(configKey);
        });
    }

    protected void updateObjMap(String configKey) {
        for (Map.Entry<String, QpsController> controllerEntry : this.qualifiedNameControllerMap.entrySet()) {
            if (!this.keyMatch(configKey, controllerEntry)) continue;
            QpsController qpsController = this.searchQpsController(controllerEntry.getKey());
            controllerEntry.setValue(qpsController);
            LOGGER.info("QpsController updated, operationId = [{}], configKey = [{}], qpsLimit = [{}]", new Object[]{controllerEntry.getKey(), qpsController.getKey(), qpsController.getQpsLimit()});
        }
    }

    public QpsControllerManager setConfigKeyPrefix(String configKeyPrefix) {
        this.configKeyPrefix = configKeyPrefix;
        return this;
    }

    public QpsControllerManager setGlobalQpsController(String globalConfigKey) {
        DynamicProperty globalQpsProperty = DynamicProperty.getInstance((String)globalConfigKey);
        QpsController qpsController = new QpsController(globalConfigKey, globalQpsProperty.getInteger());
        globalQpsProperty.addCallback(() -> {
            qpsController.setQpsLimit(globalQpsProperty.getInteger());
            LOGGER.info("Global qps limit update, value = [{}]", (Object)globalQpsProperty.getInteger());
        });
        this.globalQpsController = qpsController;
        return this;
    }

    public QpsController getGlobalQpsController() {
        return this.globalQpsController;
    }

    protected DynamicProperty getDynamicProperty(String configKey) {
        return DynamicProperty.getInstance((String)(this.configKeyPrefix + configKey));
    }
}

