/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance;

import com.google.common.collect.Lists;
import com.netflix.client.DefaultLoadBalancerRetryHandler;
import com.netflix.client.RetryHandler;
import com.netflix.client.Utils;
import java.util.Collection;
import org.apache.servicecomb.loadbalance.Configuration;
import org.apache.servicecomb.loadbalance.ExtensionsFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultRetryExtensionsFactory
implements ExtensionsFactory {
    private static final Collection<String> ACCEPT_KEYS = Lists.newArrayList((Object[])new String[]{"retryHandler"});
    private static final String RETRY_DEFAULT = "default";
    private static final Collection<String> ACCEPT_VALUES = Lists.newArrayList((Object[])new String[]{"default"});

    @Override
    public boolean isSupport(String key, String value) {
        return ACCEPT_KEYS.contains(key) && ACCEPT_VALUES.contains(value);
    }

    @Override
    public RetryHandler createRetryHandler(String retryName, String microservice) {
        DefaultLoadBalancerRetryHandler handler = new DefaultLoadBalancerRetryHandler(Configuration.INSTANCE.getRetryOnSame(microservice), Configuration.INSTANCE.getRetryOnNext(microservice), true){

            public boolean isRetriableException(Throwable e, boolean sameServer) {
                return Utils.isPresentAsCause((Throwable)e, (Collection)this.getRetriableExceptions());
            }
        };
        return handler;
    }
}

