/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance;

import com.netflix.client.RetryHandler;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.RoundRobinRule;
import java.util.ArrayList;
import java.util.List;
import org.apache.servicecomb.loadbalance.Configuration;
import org.apache.servicecomb.loadbalance.ExtensionsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionsManager.class);
    private static List<ExtensionsFactory> extentionFactories = new ArrayList<ExtensionsFactory>();

    public static void addExtentionsFactory(ExtensionsFactory factory) {
        extentionFactories.add(factory);
    }

    public static IRule createLoadBalancerRule(String microservice) {
        RoundRobinRule rule = null;
        for (ExtensionsFactory factory : extentionFactories) {
            if (factory.isSupport("NFLoadBalancerRuleClassName", Configuration.INSTANCE.getPolicy(microservice))) {
                rule = factory.createLoadBalancerRule(Configuration.INSTANCE.getPolicy(microservice));
                break;
            }
            if (!factory.isSupport("strategy.name", Configuration.INSTANCE.getRuleStrategyName(microservice))) continue;
            rule = factory.createLoadBalancerRule(Configuration.INSTANCE.getRuleStrategyName(microservice));
            break;
        }
        if (rule == null) {
            rule = new RoundRobinRule();
        }
        LOGGER.info("Using load balance rule {} for microservice {}.", (Object)rule.getClass().getName(), (Object)microservice);
        return rule;
    }

    public static RetryHandler createRetryHandler(String microservice) {
        Object handler = null;
        for (ExtensionsFactory factory : extentionFactories) {
            if (!factory.isSupport("retryHandler", Configuration.INSTANCE.getRetryHandler(microservice))) continue;
            handler = factory.createRetryHandler(Configuration.INSTANCE.getRetryHandler(microservice), microservice);
            break;
        }
        LOGGER.debug("Using retry handler {} for microservice {}.", (Object)handler.getClass().getName(), (Object)microservice);
        return handler;
    }
}

