/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.LoadBalancerStats;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.WeightedResponseTimeRule;
import java.util.Collections;
import java.util.List;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.loadbalance.LoadBalancer;
import org.apache.servicecomb.loadbalance.ServerListFilterExt;

public class LoadBalancerCreator {
    private List<Server> serverList = Collections.emptyList();
    private IRule rule;
    private LoadBalancerStats lbStats;
    private List<ServerListFilterExt> filters;
    private String microServiceName;

    public LoadBalancerCreator(IRule rule, String microServiceName) {
        this.rule = rule;
        this.microServiceName = microServiceName;
        this.lbStats = new LoadBalancerStats(null);
        this.filters = SPIServiceUtils.loadSortedService(ServerListFilterExt.class);
    }

    public void shutdown() {
        if (this.rule instanceof WeightedResponseTimeRule) {
            ((WeightedResponseTimeRule)this.rule).shutdown();
        }
    }

    public void setServerList(List<Server> serverList) {
        this.serverList = Collections.unmodifiableList(serverList);
    }

    @VisibleForTesting
    void setFilters(List<ServerListFilterExt> filters) {
        this.filters = filters;
    }

    public LoadBalancer createLoadBalancer(Invocation invocation) {
        LoadBalancer loadBalancer = new LoadBalancer(this.rule, this.microServiceName, this.lbStats);
        List<Server> servers = this.serverList;
        for (ServerListFilterExt filter : this.filters) {
            filter.setLoadBalancer(loadBalancer);
            servers = filter.getFilteredListOfServers(servers, invocation);
        }
        loadBalancer.setServerList(servers);
        return loadBalancer;
    }
}

