/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance;

import java.util.concurrent.atomic.AtomicLong;

public class ServiceCombServerStats {
    private static final long TIME_WINDOW_IN_MILLISECONDS = 60000L;
    private long lastWindow = System.currentTimeMillis();
    private Object lock = new Object();
    private AtomicLong continuousFailureCount = new AtomicLong(0L);
    private long lastVisitTime = System.currentTimeMillis();
    private long lastActiveTime = System.currentTimeMillis();
    private AtomicLong totalRequests = new AtomicLong(0L);
    private AtomicLong successRequests = new AtomicLong(0L);
    private AtomicLong failedRequests = new AtomicLong(0L);
    private boolean isolated = false;

    public void markIsolated(boolean isolated) {
        this.isolated = isolated;
    }

    public void markSuccess() {
        long time = System.currentTimeMillis();
        this.ensureWindow(time);
        this.lastVisitTime = time;
        this.lastActiveTime = time;
        this.totalRequests.incrementAndGet();
        this.successRequests.incrementAndGet();
        this.continuousFailureCount.set(0L);
    }

    public void markFailure() {
        long time = System.currentTimeMillis();
        this.ensureWindow(time);
        this.lastVisitTime = time;
        if (!this.isolated) {
            this.totalRequests.incrementAndGet();
            this.failedRequests.incrementAndGet();
            this.continuousFailureCount.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureWindow(long time) {
        if (time - this.lastWindow > 60000L) {
            Object object = this.lock;
            synchronized (object) {
                if (time - this.lastWindow > 60000L) {
                    if (!this.isolated) {
                        this.continuousFailureCount.set(0L);
                        this.totalRequests.set(0L);
                        this.successRequests.set(0L);
                        this.failedRequests.set(0L);
                    }
                    this.lastWindow = time;
                }
            }
        }
    }

    public long getLastVisitTime() {
        return this.lastVisitTime;
    }

    public long getLastActiveTime() {
        return this.lastActiveTime;
    }

    public long getCountinuousFailureCount() {
        return this.continuousFailureCount.get();
    }

    public long getTotalRequests() {
        return this.totalRequests.get();
    }

    public long getSuccessRequests() {
        return this.successRequests.get();
    }

    public long getFailedRequests() {
        return this.failedRequests.get();
    }

    public int getSuccessRate() {
        if (this.totalRequests.get() == 0L) {
            return 0;
        }
        return (int)(this.successRequests.get() * 100L / this.totalRequests.get());
    }

    public int getFailedRate() {
        if (this.totalRequests.get() == 0L) {
            return 0;
        }
        return (int)(this.failedRequests.get() * 100L / this.totalRequests.get());
    }

    public boolean isIsolated() {
        return this.isolated;
    }
}

