/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.Handler;
import org.apache.servicecomb.core.Transport;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.event.InvocationStartEvent;
import org.apache.servicecomb.core.provider.consumer.ReferenceConfig;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.swagger.invocation.InvocationType;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.SwaggerInvocation;

public class Invocation
extends SwaggerInvocation {
    private ReferenceConfig referenceConfig;
    private SchemaMeta schemaMeta;
    private OperationMeta operationMeta;
    private Endpoint endpoint;
    private Map<String, Object> handlerContext;
    private List<Handler> handlerList;
    private int handlerIndex;
    private Executor responseExecutor;
    private long startTime;
    private long startExecutionTime;
    private boolean sync;

    public long getStartTime() {
        return this.startTime;
    }

    public long getStartExecutionTime() {
        return this.startExecutionTime;
    }

    public Invocation(ReferenceConfig referenceConfig, OperationMeta operationMeta, Object[] swaggerArguments) {
        this.handlerContext = this.localContext;
        this.sync = true;
        this.invocationType = InvocationType.CONSUMER;
        this.referenceConfig = referenceConfig;
        this.init(operationMeta, swaggerArguments);
    }

    public Invocation(Endpoint endpoint, OperationMeta operationMeta, Object[] swaggerArguments) {
        this.handlerContext = this.localContext;
        this.sync = true;
        this.invocationType = InvocationType.PRODUCER;
        this.endpoint = endpoint;
        this.init(operationMeta, swaggerArguments);
    }

    private void init(OperationMeta operationMeta, Object[] swaggerArguments) {
        this.schemaMeta = operationMeta.getSchemaMeta();
        this.operationMeta = operationMeta;
        this.swaggerArguments = swaggerArguments;
        this.handlerList = this.getHandlerChain();
        this.handlerIndex = 0;
    }

    public Transport getTransport() {
        if (this.endpoint == null) {
            throw new IllegalStateException("Endpoint is empty. Forget to configure \"loadbalance\" in consumer handler chain?");
        }
        return this.endpoint.getTransport();
    }

    public List<Handler> getHandlerChain() {
        return InvocationType.CONSUMER.equals((Object)this.invocationType) ? this.schemaMeta.getConsumerHandlerChain() : this.schemaMeta.getProviderHandlerChain();
    }

    public Executor getResponseExecutor() {
        return this.responseExecutor;
    }

    public void setResponseExecutor(Executor responseExecutor) {
        this.responseExecutor = responseExecutor;
    }

    public SchemaMeta getSchemaMeta() {
        return this.schemaMeta;
    }

    public OperationMeta getOperationMeta() {
        return this.operationMeta;
    }

    public Object[] getArgs() {
        return this.swaggerArguments;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Map<String, Object> getHandlerContext() {
        return this.handlerContext;
    }

    public int getHandlerIndex() {
        return this.handlerIndex;
    }

    public void setHandlerIndex(int handlerIndex) {
        this.handlerIndex = handlerIndex;
    }

    public void next(AsyncResponse asyncResp) throws Exception {
        int runIndex = this.handlerIndex++;
        this.handlerList.get(runIndex).handle(this, asyncResp);
    }

    public String getSchemaId() {
        return this.schemaMeta.getSchemaId();
    }

    public String getOperationName() {
        return this.operationMeta.getOperationId();
    }

    public String getConfigTransportName() {
        return this.referenceConfig.getTransport();
    }

    public String getRealTransportName() {
        return this.endpoint != null ? this.endpoint.getTransport().getName() : this.getConfigTransportName();
    }

    public String getMicroserviceName() {
        return this.schemaMeta.getMicroserviceName();
    }

    public String getAppId() {
        return this.schemaMeta.getMicroserviceMeta().getAppId();
    }

    public String getMicroserviceVersionRule() {
        return this.referenceConfig.getVersionRule();
    }

    public String getInvocationQualifiedName() {
        return this.invocationType.name() + " " + this.getRealTransportName() + " " + this.getOperationMeta().getMicroserviceQualifiedName();
    }

    public String getMicroserviceQualifiedName() {
        return this.operationMeta.getMicroserviceQualifiedName();
    }

    public void onStart() {
        this.startTime = System.nanoTime();
        EventManager.post((Object)new InvocationStartEvent(this));
    }

    public void onStartExecute() {
        this.startExecutionTime = System.nanoTime();
    }

    public void onFinish(Response response) {
        EventManager.post((Object)new InvocationFinishEvent(this, response));
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public boolean isConsumer() {
        return InvocationType.CONSUMER.equals((Object)this.invocationType);
    }
}

