/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.definition.schema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.swagger.models.Operation;
import io.swagger.models.Swagger;
import io.swagger.util.Yaml;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.inject.Inject;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.core.definition.schema.AbstractSchemaFactory;
import org.apache.servicecomb.core.definition.schema.ProducerSchemaContext;
import org.apache.servicecomb.core.executor.ExecutorManager;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;
import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.apache.servicecomb.swagger.engine.SwaggerEnvironment;
import org.apache.servicecomb.swagger.engine.SwaggerProducer;
import org.apache.servicecomb.swagger.engine.SwaggerProducerOperation;
import org.apache.servicecomb.swagger.generator.core.SwaggerGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProducerSchemaFactory
extends AbstractSchemaFactory<ProducerSchemaContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProducerSchemaFactory.class);
    @Inject
    private SwaggerEnvironment swaggerEnv;
    private ObjectWriter writer = Yaml.pretty();

    private String getSwaggerContent(Swagger swagger) {
        try {
            return this.writer.writeValueAsString((Object)swagger);
        }
        catch (JsonProcessingException e) {
            throw new Error(e);
        }
    }

    public void setSwaggerEnv(SwaggerEnvironment swaggerEnv) {
        this.swaggerEnv = swaggerEnv;
    }

    public SchemaMeta getOrCreateProducerSchema(String microserviceName, String schemaId, Class<?> producerClass, Object producerInstance) {
        MicroserviceMeta microserviceMeta = this.microserviceMetaManager.getOrCreateMicroserviceMeta(microserviceName);
        ProducerSchemaContext context = new ProducerSchemaContext();
        context.setMicroserviceMeta(microserviceMeta);
        context.setSchemaId(schemaId);
        context.setProviderClass(producerClass);
        context.setProducerInstance(producerInstance);
        SchemaMeta schemaMeta = this.getOrCreateSchema(context);
        SwaggerProducer producer = this.swaggerEnv.createProducer(producerInstance, schemaMeta.getSwaggerIntf(), this.convertSwaggerOperationMap(schemaMeta));
        Executor reactiveExecutor = (Executor)BeanUtils.getBean((String)"servicecomb.executor.reactive");
        for (OperationMeta operationMeta : schemaMeta.getOperations()) {
            SwaggerProducerOperation producerOperation = producer.findOperation(operationMeta.getOperationId());
            operationMeta.putExtData("producer-operation", producerOperation);
            if (!CompletableFuture.class.equals(producerOperation.getProducerMethod().getReturnType())) continue;
            operationMeta.setExecutor(ExecutorManager.findExecutor(operationMeta, reactiveExecutor));
        }
        return schemaMeta;
    }

    private Map<String, Operation> convertSwaggerOperationMap(SchemaMeta schemaMeta) {
        LinkedHashMap<String, Operation> operationMap = new LinkedHashMap<String, Operation>(schemaMeta.getOperations().size());
        schemaMeta.getOperations().forEach(operationMeta -> operationMap.put(operationMeta.getOperationId(), operationMeta.getSwaggerOperation()));
        return operationMap;
    }

    @Override
    protected SchemaMeta createSchema(ProducerSchemaContext context) {
        Swagger swagger = this.loadSwagger(context);
        if (swagger == null) {
            String name;
            Set combinedNames = RegistryUtils.getServiceRegistry().getCombinedMicroserviceNames();
            Iterator iterator = combinedNames.iterator();
            while (iterator.hasNext() && (swagger = this.loadSwagger(name = (String)iterator.next(), context.getSchemaId())) == null) {
            }
        }
        if (swagger == null) {
            SwaggerGenerator generator = this.generateSwagger(context);
            swagger = generator.getSwagger();
            String swaggerContent = this.getSwaggerContent(swagger);
            LOGGER.info("generate swagger for {}/{}/{}, swagger: {}", new Object[]{context.getMicroserviceMeta().getAppId(), context.getMicroserviceName(), context.getSchemaId(), swaggerContent});
        }
        return this.schemaLoader.registerSchema(context.getMicroserviceMeta(), context.getSchemaId(), swagger);
    }
}

