/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.provider.consumer;

import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.MicroserviceVersionMeta;
import org.apache.servicecomb.serviceregistry.consumer.AppManager;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceVersion;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceVersionRule;

public class ReferenceConfig {
    private MicroserviceVersionRule microserviceVersionRule;
    private String transport = "";

    public ReferenceConfig() {
    }

    public ReferenceConfig(AppManager appManager, String microserviceName, String versionRule, String transport) {
        String appId = new MicroserviceMeta(microserviceName).getAppId();
        this.microserviceVersionRule = appManager.getOrCreateMicroserviceVersionRule(appId, microserviceName, versionRule);
        this.transport = transport;
    }

    public MicroserviceMeta getMicroserviceMeta() {
        MicroserviceVersion microserviceVersion = this.microserviceVersionRule.getLatestMicroserviceVersion();
        if (microserviceVersion == null) {
            throw new IllegalStateException(String.format("Probably invoke a service before it is registered, or no instance found for it, appId=%s, name=%s", this.microserviceVersionRule.getAppId(), this.microserviceVersionRule.getMicroserviceName()));
        }
        return ((MicroserviceVersionMeta)microserviceVersion).getMicroserviceMeta();
    }

    public MicroserviceVersionRule getMicroserviceVersionRule() {
        return this.microserviceVersionRule;
    }

    public String getVersionRule() {
        return this.microserviceVersionRule.getVersionRule().getVersionRule();
    }

    public void setMicroserviceVersionRule(MicroserviceVersionRule microserviceVersionRule) {
        this.microserviceVersionRule = microserviceVersionRule;
    }

    public String getTransport() {
        return this.transport;
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }
}

