/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.unittest;

import io.swagger.models.Swagger;
import java.util.Collections;
import java.util.List;
import mockit.Mock;
import mockit.MockUp;
import org.apache.servicecomb.core.CseContext;
import org.apache.servicecomb.core.Handler;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.MicroserviceMetaManager;
import org.apache.servicecomb.core.definition.PrivateMicroserviceVersionMetaFactory;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.core.definition.loader.SchemaListenerManager;
import org.apache.servicecomb.core.definition.loader.SchemaLoader;
import org.apache.servicecomb.core.definition.schema.ConsumerSchemaFactory;
import org.apache.servicecomb.core.handler.ConsumerHandlerManager;
import org.apache.servicecomb.core.handler.ProducerHandlerManager;
import org.apache.servicecomb.core.handler.config.Config;
import org.apache.servicecomb.core.handler.impl.SimpleLoadBalanceHandler;
import org.apache.servicecomb.core.provider.consumer.ConsumerProviderManager;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;
import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.apache.servicecomb.serviceregistry.ServiceRegistry;
import org.apache.servicecomb.serviceregistry.api.registry.Microservice;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceVersionFactory;
import org.apache.servicecomb.serviceregistry.registry.ServiceRegistryFactory;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.generator.core.SwaggerGenerator;
import org.apache.servicecomb.swagger.generator.core.SwaggerGeneratorContext;
import org.apache.servicecomb.swagger.generator.core.unittest.UnitTestSwaggerUtils;
import org.mockito.Mockito;
import org.springframework.context.ApplicationContext;

public class UnitTestMeta {
    private MicroserviceMetaManager microserviceMetaManager = new MicroserviceMetaManager();
    private SchemaListenerManager schemaListenerManager = new SchemaListenerManager();
    private ConsumerProviderManager consumerProviderManager;
    private ConsumerSchemaFactory consumerSchemaFactory;
    private SchemaLoader schemaLoader = new SchemaLoader();
    private ServiceRegistry serviceRegistry;

    public ConsumerProviderManager getConsumerProviderManager() {
        return this.consumerProviderManager;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public ConsumerSchemaFactory getConsumerSchemaFactory() {
        return this.consumerSchemaFactory;
    }

    public void init() {
        this.serviceRegistry = ServiceRegistryFactory.createLocal();
        this.serviceRegistry.init();
        this.serviceRegistry.getAppManager().setMicroserviceVersionFactory((MicroserviceVersionFactory)new PrivateMicroserviceVersionMetaFactory());
        RegistryUtils.setServiceRegistry((ServiceRegistry)this.serviceRegistry);
        this.schemaLoader.setMicroserviceMetaManager(this.microserviceMetaManager);
        this.consumerProviderManager = new ConsumerProviderManager();
        this.consumerSchemaFactory = new ConsumerSchemaFactory();
        this.consumerSchemaFactory.setMicroserviceMetaManager(this.microserviceMetaManager);
        this.consumerSchemaFactory.setSchemaLoader(this.schemaLoader);
        this.consumerProviderManager.setAppManager(RegistryUtils.getServiceRegistry().getAppManager());
        CseContext.getInstance().setConsumerProviderManager(this.consumerProviderManager);
        CseContext.getInstance().setConsumerSchemaFactory(this.consumerSchemaFactory);
        CseContext.getInstance().setSchemaListenerManager(this.schemaListenerManager);
        Config config = new Config();
        Class<SimpleLoadBalanceHandler> cls = SimpleLoadBalanceHandler.class;
        config.getHandlerClassMap().put("simpleLB", cls);
        ProducerHandlerManager.INSTANCE.init(new Config());
        ConsumerHandlerManager.INSTANCE.init(config);
        ApplicationContext applicationContext = (ApplicationContext)Mockito.mock(ApplicationContext.class);
        Mockito.when((Object)applicationContext.getBean(Mockito.anyString())).thenReturn(null);
        BeanUtils.setContext((ApplicationContext)applicationContext);
    }

    public UnitTestMeta() {
        new MockUp<ConsumerHandlerManager>(){

            @Mock
            public List<Handler> getOrCreate(String name) {
                return Collections.emptyList();
            }
        };
        new MockUp<ProducerHandlerManager>(){

            @Mock
            public List<Handler> getOrCreate(String name) {
                return Collections.emptyList();
            }
        };
        this.init();
    }

    public MicroserviceMetaManager getMicroserviceMetaManager() {
        return this.microserviceMetaManager;
    }

    public SchemaMeta getOrCreateSchemaMeta(Class<?> impl) {
        return this.getOrCreateSchemaMeta("app", "test", impl.getName(), impl);
    }

    public SchemaMeta getOrCreateSchemaMeta(String appId, String microserviceName, String schemaId, Class<?> impl) {
        String longName = appId + ":" + microserviceName;
        MicroserviceMeta microserviceMeta = this.microserviceMetaManager.getOrCreateMicroserviceMeta(longName);
        SchemaMeta schemaMeta = microserviceMeta.findSchemaMeta(schemaId);
        if (schemaMeta != null) {
            return schemaMeta;
        }
        Swagger swagger = UnitTestSwaggerUtils.generateSwagger(impl).getSwagger();
        return this.schemaLoader.registerSchema(microserviceMeta, schemaId, swagger);
    }

    public void registerSchema(SwaggerGeneratorContext swaggerGeneratorContext, Class<?> schemaCls) {
        SwaggerGenerator swaggerGenerator = new SwaggerGenerator(swaggerGeneratorContext, schemaCls);
        swaggerGenerator.setClassLoader(new ClassLoader(){});
        Swagger swagger = swaggerGenerator.generate();
        Microservice microservice = new Microservice();
        microservice.setAppId("app");
        microservice.setServiceName("app:test");
        microservice.setVersion("1.0.0");
        microservice.getSchemas().add(schemaCls.getName());
        microservice.setServiceId(this.serviceRegistry.getServiceRegistryClient().registerMicroservice(microservice));
        this.serviceRegistry.getServiceRegistryClient().registerSchema(microservice.getServiceId(), schemaCls.getName(), SwaggerUtils.swaggerToString((Swagger)swagger));
        MicroserviceInstance instance = new MicroserviceInstance();
        instance.setServiceId(microservice.getServiceId());
        instance.setInstanceId(this.serviceRegistry.getServiceRegistryClient().registerMicroserviceInstance(instance));
    }
}

