/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.client;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.foundation.vertx.AsyncResultCallback;
import org.apache.servicecomb.serviceregistry.api.registry.Microservice;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.serviceregistry.api.registry.ServiceCenterConfig;
import org.apache.servicecomb.serviceregistry.api.registry.ServiceCenterInfo;
import org.apache.servicecomb.serviceregistry.api.response.FindInstancesResponse;
import org.apache.servicecomb.serviceregistry.api.response.GetSchemaResponse;
import org.apache.servicecomb.serviceregistry.api.response.HeartbeatResponse;
import org.apache.servicecomb.serviceregistry.api.response.MicroserviceInstanceChangedEvent;
import org.apache.servicecomb.serviceregistry.client.ServiceRegistryClient;
import org.apache.servicecomb.serviceregistry.client.http.Holder;
import org.apache.servicecomb.serviceregistry.client.http.MicroserviceInstances;
import org.apache.servicecomb.serviceregistry.version.Version;
import org.apache.servicecomb.serviceregistry.version.VersionRule;
import org.apache.servicecomb.serviceregistry.version.VersionRuleUtils;
import org.apache.servicecomb.serviceregistry.version.VersionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.yaml.snakeyaml.Yaml;

public class LocalServiceRegistryClientImpl
implements ServiceRegistryClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalServiceRegistryClientImpl.class);
    public static final String LOCAL_REGISTRY_FILE_KEY = "local.registry.file";
    private final String LOCAL_REGISTRY_FILE = System.getProperty("local.registry.file");
    private Map<String, Microservice> microserviceIdMap = new ConcurrentHashMap<String, Microservice>();
    private Map<String, Map<String, MicroserviceInstance>> microserviceInstanceMap = new ConcurrentHashMap<String, Map<String, MicroserviceInstance>>();
    private AtomicInteger revision = new AtomicInteger(0);

    public LocalServiceRegistryClientImpl() {
        if (StringUtils.isEmpty((Object)this.LOCAL_REGISTRY_FILE)) {
            LOGGER.info("create empty local registry.");
            return;
        }
        File file = new File(this.LOCAL_REGISTRY_FILE);
        if (!file.exists()) {
            return;
        }
        try (FileInputStream is = new FileInputStream(file);){
            this.initFromData(is);
        }
        catch (IOException e) {
            LOGGER.error("can not load local registry file:" + this.LOCAL_REGISTRY_FILE, (Throwable)e);
        }
    }

    public LocalServiceRegistryClientImpl(InputStream is) {
        this.initFromData(is);
    }

    public LocalServiceRegistryClientImpl(Map<String, Object> data) {
        this.initFromData(data);
    }

    private void initFromData(InputStream is) {
        Yaml yaml = new Yaml();
        Map data = (Map)yaml.loadAs(is, Map.class);
        this.initFromData(data);
    }

    private void initFromData(Map<String, Object> data) {
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            String name = entry.getKey();
            List serviceConfigs = (List)entry.getValue();
            for (Map serviceConfig : serviceConfigs) {
                List instancesConfig = (List)serviceConfig.get("instances");
                String appId = (String)serviceConfig.get("appid");
                String version = (String)serviceConfig.get("version");
                String serviceId = (String)serviceConfig.get("id");
                List schemas = (List)serviceConfig.get("schemaIds");
                Microservice microservice = new Microservice();
                microservice.setAppId(appId == null ? "default" : appId);
                microservice.setServiceName(name);
                microservice.setVersion(version);
                microservice.setServiceId(serviceId == null ? UUID.randomUUID().toString() : serviceId);
                this.microserviceIdMap.put(microservice.getServiceId(), microservice);
                if (schemas != null) {
                    microservice.setSchemas(schemas);
                }
                ConcurrentHashMap<String, MicroserviceInstance> instanceMap = new ConcurrentHashMap<String, MicroserviceInstance>();
                for (Map instanceConfig : instancesConfig) {
                    List endpoints = (List)instanceConfig.get("endpoints");
                    MicroserviceInstance instance = new MicroserviceInstance();
                    instance.setInstanceId(UUID.randomUUID().toString());
                    instance.setEndpoints(endpoints);
                    instance.setServiceId(microservice.getServiceId());
                    instanceMap.put(instance.getInstanceId(), instance);
                }
                this.microserviceInstanceMap.put(microservice.getServiceId(), instanceMap);
            }
        }
        if (!data.isEmpty()) {
            this.revision.incrementAndGet();
        }
    }

    @Override
    public void init() {
    }

    @Override
    public List<Microservice> getAllMicroservices() {
        return new ArrayList<Microservice>(this.microserviceIdMap.values());
    }

    @Override
    public String getMicroserviceId(String appId, String microserviceName, String strVersionRule, String environment) {
        VersionRule versionRule = VersionRuleUtils.getOrCreate(strVersionRule);
        Microservice latest = this.findLatest(appId, microserviceName, versionRule);
        return latest != null ? latest.getServiceId() : null;
    }

    @Override
    public String registerMicroservice(Microservice microservice) {
        String serviceId = microservice.getServiceId();
        if (serviceId == null) {
            serviceId = UUID.randomUUID().toString();
            microservice.setServiceId(serviceId);
        }
        this.microserviceIdMap.put(serviceId, microservice);
        this.microserviceInstanceMap.computeIfAbsent(serviceId, k -> new ConcurrentHashMap());
        this.revision.incrementAndGet();
        return serviceId;
    }

    @Override
    public Microservice getMicroservice(String microserviceId) {
        return this.microserviceIdMap.get(microserviceId);
    }

    @Override
    public String registerMicroserviceInstance(MicroserviceInstance instance) {
        Map<String, MicroserviceInstance> instanceMap = this.microserviceInstanceMap.get(instance.getServiceId());
        if (instanceMap == null) {
            throw new IllegalArgumentException("Invalid serviceId of instance, serviceId=" + instance.getServiceId());
        }
        String instanceId = instance.getInstanceId() == null ? UUID.randomUUID().toString() : instance.getInstanceId();
        instanceMap.put(instanceId, instance);
        this.revision.incrementAndGet();
        return instanceId;
    }

    @Override
    public List<MicroserviceInstance> getMicroserviceInstance(String consumerId, String providerId) {
        Map<String, MicroserviceInstance> instanceMap = this.microserviceInstanceMap.get(providerId);
        if (instanceMap == null) {
            throw new IllegalArgumentException("Invalid serviceId, serviceId=" + providerId);
        }
        return new ArrayList<MicroserviceInstance>(instanceMap.values());
    }

    @Override
    public boolean unregisterMicroserviceInstance(String microserviceId, String microserviceInstanceId) {
        Map<String, MicroserviceInstance> instanceMap = this.microserviceInstanceMap.get(microserviceId);
        if (instanceMap != null) {
            instanceMap.remove(microserviceInstanceId);
            this.revision.getAndIncrement();
        }
        return true;
    }

    @Override
    public HeartbeatResponse heartbeat(String microserviceId, String microserviceInstanceId) {
        HeartbeatResponse response = new HeartbeatResponse();
        response.setMessage("OK");
        response.setOk(true);
        return response;
    }

    @Override
    public void watch(String selfMicroserviceId, AsyncResultCallback<MicroserviceInstanceChangedEvent> callback) {
        this.watch(selfMicroserviceId, callback, (AsyncResultCallback<Void>)((AsyncResultCallback)v -> {}), (AsyncResultCallback<Void>)((AsyncResultCallback)v -> {}));
    }

    @Override
    public void watch(String selfMicroserviceId, AsyncResultCallback<MicroserviceInstanceChangedEvent> callback, AsyncResultCallback<Void> onOpen, AsyncResultCallback<Void> onClose) {
    }

    protected boolean isSameMicroservice(Microservice microservice, String appId, String serviceName) {
        return microservice.getAppId().equals(appId) && microservice.getServiceName().equals(serviceName);
    }

    protected Microservice findLatest(String appId, String serviceName, VersionRule versionRule) {
        Version latestVersion = null;
        Microservice latest = null;
        for (Map.Entry<String, Microservice> entry : this.microserviceIdMap.entrySet()) {
            Version version;
            Microservice microservice = entry.getValue();
            if (!this.isSameMicroservice(microservice, appId, serviceName) || !versionRule.isAccept(version = VersionUtils.getOrCreate(microservice.getVersion())) || latestVersion != null && version.compareTo(latestVersion) <= 0) continue;
            latestVersion = version;
            latest = microservice;
        }
        return latest;
    }

    @Override
    public List<MicroserviceInstance> findServiceInstance(String selfMicroserviceId, String appId, String serviceName, String strVersionRule) {
        MicroserviceInstances instances = this.findServiceInstances(selfMicroserviceId, appId, serviceName, strVersionRule, null);
        if (instances.isMicroserviceNotExist()) {
            return null;
        }
        return instances.getInstancesResponse().getInstances();
    }

    @Override
    public MicroserviceInstances findServiceInstances(String selfMicroserviceId, String appId, String serviceName, String strVersionRule, String revision) {
        int currentRevision = this.revision.get();
        ArrayList<MicroserviceInstance> allInstances = new ArrayList<MicroserviceInstance>();
        MicroserviceInstances microserviceInstances = new MicroserviceInstances();
        FindInstancesResponse response = new FindInstancesResponse();
        if (revision != null && currentRevision == Integer.parseInt(revision)) {
            microserviceInstances.setNeedRefresh(false);
            return microserviceInstances;
        }
        microserviceInstances.setRevision(String.valueOf(currentRevision));
        VersionRule versionRule = VersionRuleUtils.getOrCreate(strVersionRule);
        Microservice latestMicroservice = this.findLatest(appId, serviceName, versionRule);
        if (latestMicroservice == null) {
            microserviceInstances.setMicroserviceNotExist(true);
            return microserviceInstances;
        }
        Version latestVersion = VersionUtils.getOrCreate(latestMicroservice.getVersion());
        for (Map.Entry<String, Microservice> entry : this.microserviceIdMap.entrySet()) {
            Version version;
            Microservice microservice = entry.getValue();
            if (!this.isSameMicroservice(microservice, appId, serviceName) || !versionRule.isMatch(version = VersionUtils.getOrCreate(entry.getValue().getVersion()), latestVersion)) continue;
            Map<String, MicroserviceInstance> instances = this.microserviceInstanceMap.get(entry.getValue().getServiceId());
            allInstances.addAll(instances.values());
        }
        response.setInstances(allInstances);
        microserviceInstances.setInstancesResponse(response);
        return microserviceInstances;
    }

    @Override
    public boolean isSchemaExist(String microserviceId, String schemaId) {
        Microservice microservice = this.microserviceIdMap.get(microserviceId);
        if (microservice == null) {
            throw new IllegalArgumentException("Invalid serviceId, serviceId=" + microserviceId);
        }
        return microservice.getSchemaMap().containsKey(schemaId);
    }

    @Override
    public boolean registerSchema(String microserviceId, String schemaId, String schemaContent) {
        Microservice microservice = this.microserviceIdMap.get(microserviceId);
        if (microservice == null) {
            throw new IllegalArgumentException("Invalid serviceId, serviceId=" + microserviceId);
        }
        microservice.getSchemaMap().put(schemaId, schemaContent);
        return true;
    }

    @Override
    public String getSchema(String microserviceId, String schemaId) {
        Microservice microservice = this.microserviceIdMap.get(microserviceId);
        if (microservice == null) {
            throw new IllegalArgumentException("Invalid serviceId, serviceId=" + microserviceId);
        }
        return microservice.getSchemaMap().get(schemaId);
    }

    @Override
    public Holder<List<GetSchemaResponse>> getSchemas(String microserviceId) {
        Microservice microservice = this.microserviceIdMap.get(microserviceId);
        if (microservice == null) {
            throw new IllegalArgumentException("Invalid serviceId, serviceId=" + microserviceId);
        }
        ArrayList schemas = new ArrayList();
        microservice.getSchemaMap().forEach((key, val) -> {
            GetSchemaResponse schema = new GetSchemaResponse();
            schema.setSchema((String)val);
            schema.setSchemaId((String)key);
            schema.setSummary(Hashing.sha256().newHasher().putString((CharSequence)val, Charsets.UTF_8).hash().toString());
            schemas.add(schema);
        });
        Holder<List<GetSchemaResponse>> resultHolder = new Holder<List<GetSchemaResponse>>();
        resultHolder.setStatusCode(Response.Status.OK.getStatusCode()).setValue(schemas);
        return resultHolder;
    }

    @Override
    public boolean updateMicroserviceProperties(String microserviceId, Map<String, String> serviceProperties) {
        Microservice microservice = this.microserviceIdMap.get(microserviceId);
        if (microservice == null) {
            throw new IllegalArgumentException("Invalid serviceId, serviceId=" + microserviceId);
        }
        if (serviceProperties != null) {
            microservice.getProperties().putAll(serviceProperties);
        }
        return true;
    }

    @Override
    public boolean updateInstanceProperties(String microserviceId, String microserviceInstanceId, Map<String, String> instanceProperties) {
        Map<String, MicroserviceInstance> instanceMap = this.microserviceInstanceMap.get(microserviceId);
        if (instanceMap == null) {
            throw new IllegalArgumentException("Invalid serviceId, serviceId=" + microserviceId);
        }
        MicroserviceInstance microserviceInstance = instanceMap.get(microserviceInstanceId);
        if (microserviceInstance == null) {
            throw new IllegalArgumentException(String.format("Invalid argument. microserviceId=%s, microserviceInstanceId=%s.", microserviceId, microserviceInstanceId));
        }
        if (instanceProperties != null) {
            microserviceInstance.getProperties().putAll(instanceProperties);
        }
        return true;
    }

    @Override
    public MicroserviceInstance findServiceInstance(String serviceId, String instanceId) {
        Map<String, MicroserviceInstance> instances = this.microserviceInstanceMap.get(serviceId);
        return instances.get(instanceId);
    }

    @Override
    public ServiceCenterInfo getServiceCenterInfo() {
        ServiceCenterInfo info = new ServiceCenterInfo();
        info.setVersion("1.0.0");
        info.setBuildTag("20180312");
        info.setRunMode("dev");
        info.setApiVersion("4.0.0");
        info.setConfig(new ServiceCenterConfig());
        return info;
    }
}

