/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.consumer;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.servicecomb.foundation.common.cache.VersionedCache;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.serviceregistry.cache.InstanceCache;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceVersion;
import org.apache.servicecomb.serviceregistry.version.VersionRule;
import org.apache.servicecomb.serviceregistry.version.VersionRuleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroserviceVersionRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroserviceVersionRule.class);
    private final String appId;
    private final String microserviceName;
    private final VersionRule versionRule;
    private MicroserviceVersion latestVersion;
    private Map<String, MicroserviceVersion> versions = new ConcurrentHashMap<String, MicroserviceVersion>();
    private Map<String, MicroserviceInstance> instances = Collections.emptyMap();
    private InstanceCache instanceCache;
    private VersionedCache versionedCache;

    public MicroserviceVersionRule(String appId, String microserviceName, String strVersionRule) {
        this.appId = appId;
        this.microserviceName = microserviceName;
        this.versionRule = VersionRuleUtils.getOrCreate(strVersionRule);
        this.resetInstanceCache();
    }

    public String getAppId() {
        return this.appId;
    }

    public String getMicroserviceName() {
        return this.microserviceName;
    }

    private void resetInstanceCache() {
        this.instanceCache = new InstanceCache(this.appId, this.microserviceName, this.versionRule.getVersionRule(), this.instances);
        this.versionedCache = new VersionedCache().name(this.versionRule.getVersionRule()).autoCacheVersion().data(this.instances);
    }

    public void addMicroserviceVersion(MicroserviceVersion microserviceVersion) {
        if (!this.versionRule.isAccept(microserviceVersion.getVersion())) {
            return;
        }
        this.versions.put(microserviceVersion.getMicroservice().getServiceId(), microserviceVersion);
        this.resetLatestVersion();
        LOGGER.info("add microserviceVersion, appId={}, microserviceName={}, version={}, versionRule={}.", new Object[]{microserviceVersion.getMicroservice().getAppId(), microserviceVersion.getMicroservice().getServiceName(), microserviceVersion.getVersion().getVersion(), this.versionRule.getVersionRule()});
    }

    public void deleteMicroserviceVersion(MicroserviceVersion microserviceVersion) {
        if (!this.versionRule.isAccept(microserviceVersion.getVersion())) {
            return;
        }
        if (this.versions.remove(microserviceVersion.getMicroservice().getServiceId()) == null) {
            return;
        }
        this.resetLatestVersion();
        LOGGER.info("delete microserviceVersion, appId={}, microserviceName={}, version={}, versionRule={}.", new Object[]{microserviceVersion.getMicroservice().getAppId(), microserviceVersion.getMicroservice().getServiceName(), microserviceVersion.getVersion().getVersion(), this.versionRule.getVersionRule()});
    }

    protected void resetLatestVersion() {
        MicroserviceVersion lastLatestVersion = this.latestVersion;
        this.latestVersion = null;
        if (!this.versions.isEmpty()) {
            this.latestVersion = this.versions.values().stream().max(Comparator.comparing(MicroserviceVersion::getVersion)).get();
        }
        if (lastLatestVersion != this.latestVersion) {
            LOGGER.info("latestVersion changed from {} to {}, appId={}, microserviceName={}, versionRule={}.", new Object[]{lastLatestVersion == null ? "null" : lastLatestVersion.getVersion(), this.latestVersion == null ? "null" : this.latestVersion.getVersion(), this.appId, this.microserviceName, this.versionRule.getVersionRule()});
        }
    }

    public VersionRule getVersionRule() {
        return this.versionRule;
    }

    public <T extends MicroserviceVersion> T getLatestMicroserviceVersion() {
        return (T)this.latestVersion;
    }

    public Map<String, MicroserviceInstance> getInstances() {
        return this.instances;
    }

    public InstanceCache getInstanceCache() {
        return this.instanceCache;
    }

    public VersionedCache getVersionedCache() {
        return this.versionedCache;
    }

    public void setInstances(Collection<MicroserviceInstance> newInstances) {
        if (newInstances == null) {
            return;
        }
        Map tmpInstances = newInstances.stream().filter(instance -> {
            boolean isMatch;
            MicroserviceVersion microserviceVersion = this.versions.get(instance.getServiceId());
            boolean bl = isMatch = microserviceVersion != null && this.versionRule.isMatch(microserviceVersion.getVersion(), this.latestVersion.getVersion());
            if (isMatch) {
                LOGGER.info("set instances, appId={}, microserviceName={}, versionRule={}, instanceId={}, version={}, endpoints={}.", new Object[]{this.appId, this.microserviceName, this.versionRule.getVersionRule(), instance.getInstanceId(), microserviceVersion.getVersion(), instance.getEndpoints()});
            }
            return isMatch;
        }).collect(Collectors.toMap(MicroserviceInstance::getInstanceId, Function.identity()));
        this.instances = Collections.unmodifiableMap(tmpInstances);
        this.resetInstanceCache();
    }
}

