/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core.processor.annotation;

import io.swagger.annotations.Extension;
import io.swagger.annotations.License;
import io.swagger.annotations.SwaggerDefinition;
import io.swagger.models.Contact;
import io.swagger.models.ExternalDocs;
import io.swagger.models.Info;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.util.BaseReaderUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.servicecomb.swagger.generator.core.ClassAnnotationProcessor;
import org.apache.servicecomb.swagger.generator.core.SwaggerGenerator;
import org.springframework.util.StringUtils;

public class SwaggerDefinitionProcessor
implements ClassAnnotationProcessor {
    @Override
    public void process(Object annotation, SwaggerGenerator swaggerGenerator) {
        SwaggerDefinition definitionAnnotation = (SwaggerDefinition)annotation;
        Swagger swagger = swaggerGenerator.getSwagger();
        swaggerGenerator.setBasePath(definitionAnnotation.basePath());
        swagger.setHost(definitionAnnotation.host());
        this.convertConsumes(definitionAnnotation, swagger);
        this.convertProduces(definitionAnnotation, swagger);
        this.convertSchemes(definitionAnnotation, swagger);
        this.convertTags(definitionAnnotation, swagger);
        this.convertInfo(definitionAnnotation.info(), swagger);
        swagger.setExternalDocs(this.convertExternalDocs(definitionAnnotation.externalDocs()));
    }

    private void convertInfo(io.swagger.annotations.Info infoAnnotation, Swagger swagger) {
        if (infoAnnotation == null) {
            return;
        }
        Info info = new Info();
        info.setTitle(infoAnnotation.title());
        info.setVersion(infoAnnotation.version());
        info.setDescription(infoAnnotation.description());
        info.setTermsOfService(infoAnnotation.termsOfService());
        info.setContact(this.convertContact(infoAnnotation.contact()));
        info.setLicense(this.convertLicense(infoAnnotation.license()));
        info.getVendorExtensions().putAll(BaseReaderUtils.parseExtensions((Extension[])infoAnnotation.extensions()));
        swagger.setInfo(info);
    }

    private io.swagger.models.License convertLicense(License licenseAnnotation) {
        io.swagger.models.License license = new io.swagger.models.License();
        license.setName(licenseAnnotation.name());
        license.setUrl(licenseAnnotation.url());
        return license;
    }

    private Contact convertContact(io.swagger.annotations.Contact contactAnnotation) {
        Contact contact = new Contact();
        contact.setName(contactAnnotation.name());
        contact.setUrl(contactAnnotation.url());
        contact.setEmail(contactAnnotation.email());
        return contact;
    }

    private void convertTags(SwaggerDefinition definitionAnnotation, Swagger swagger) {
        if (definitionAnnotation.tags() == null) {
            return;
        }
        Stream stream = Arrays.asList(definitionAnnotation.tags()).stream();
        List tags = stream.map(this::convertTag).collect(Collectors.toList());
        swagger.setTags(tags);
    }

    private Tag convertTag(io.swagger.annotations.Tag tagAnnotation) {
        Tag tag = new Tag();
        tag.setName(tagAnnotation.name());
        tag.setDescription(tagAnnotation.description());
        tag.setExternalDocs(this.convertExternalDocs(tagAnnotation.externalDocs()));
        tag.getVendorExtensions().putAll(BaseReaderUtils.parseExtensions((Extension[])tagAnnotation.extensions()));
        return tag;
    }

    private ExternalDocs convertExternalDocs(io.swagger.annotations.ExternalDocs annotationExternalDocs) {
        ExternalDocs externalDocs = new ExternalDocs();
        externalDocs.setUrl(annotationExternalDocs.url());
        externalDocs.setDescription(annotationExternalDocs.value());
        return externalDocs;
    }

    private void convertSchemes(SwaggerDefinition definitionAnnotation, Swagger swagger) {
        if (definitionAnnotation.schemes() == null) {
            return;
        }
        Stream stream = Arrays.asList(definitionAnnotation.schemes()).stream();
        List schemes = stream.map(this::convertScheme).collect(Collectors.toList());
        swagger.setSchemes(schemes);
    }

    private Scheme convertScheme(SwaggerDefinition.Scheme annotationScheme) {
        return Scheme.forValue((String)annotationScheme.name());
    }

    private void convertProduces(SwaggerDefinition definitionAnnotation, Swagger swagger) {
        String[] produces = definitionAnnotation.produces();
        if (produces == null) {
            return;
        }
        for (String produce : produces) {
            if (StringUtils.isEmpty((Object)produce)) continue;
            swagger.addProduces(produce);
        }
    }

    private void convertConsumes(SwaggerDefinition definitionAnnotation, Swagger swagger) {
        String[] consumes = definitionAnnotation.consumes();
        if (consumes == null) {
            return;
        }
        for (String consume : consumes) {
            if (StringUtils.isEmpty((Object)consume)) continue;
            swagger.addConsumes(consume);
        }
    }
}

