/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.client;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpVersion;
import java.util.List;
import org.apache.servicecomb.common.rest.filter.HttpClientFilter;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.common.net.URIEndpointObject;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.foundation.vertx.VertxTLSBuilder;
import org.apache.servicecomb.foundation.vertx.VertxUtils;
import org.apache.servicecomb.foundation.vertx.client.ClientPoolFactory;
import org.apache.servicecomb.foundation.vertx.client.ClientPoolManager;
import org.apache.servicecomb.foundation.vertx.client.ClientVerticle;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClientPoolFactory;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClientWithContext;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.transport.rest.client.TransportClientConfig;
import org.apache.servicecomb.transport.rest.client.http.RestClientInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestTransportClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestTransportClient.class);
    private static final String SSL_KEY = "rest.consumer";
    protected ClientPoolManager<HttpClientWithContext> clientMgr;
    private ClientPoolManager<HttpClientWithContext> clientMgrHttp2;
    private List<HttpClientFilter> httpClientFilters;

    public ClientPoolManager<HttpClientWithContext> getClientMgr() {
        return this.clientMgr;
    }

    public void init(Vertx vertx) throws Exception {
        this.httpClientFilters = SPIServiceUtils.getSortedService(HttpClientFilter.class);
        HttpClientOptions httpClientOptions = RestTransportClient.createHttpClientOptions();
        this.clientMgr = new ClientPoolManager(vertx, (ClientPoolFactory)new HttpClientPoolFactory(httpClientOptions));
        HttpClientOptions httpClientOptionshttp2 = RestTransportClient.createHttpClientOptions();
        httpClientOptionshttp2.setUseAlpn(true).setProtocolVersion(HttpVersion.HTTP_2);
        httpClientOptionshttp2.setHttp2ClearTextUpgrade(false);
        this.clientMgrHttp2 = new ClientPoolManager(vertx, (ClientPoolFactory)new HttpClientPoolFactory(httpClientOptionshttp2));
        DeploymentOptions deployOptions = VertxUtils.createClientDeployOptions(this.clientMgr, (int)TransportClientConfig.getThreadCount());
        VertxUtils.blockDeploy((Vertx)vertx, ClientVerticle.class, (DeploymentOptions)deployOptions);
        DeploymentOptions deployOptionshttp2 = VertxUtils.createClientDeployOptions(this.clientMgrHttp2, (int)TransportClientConfig.getThreadCount());
        VertxUtils.blockDeploy((Vertx)vertx, ClientVerticle.class, (DeploymentOptions)deployOptionshttp2);
    }

    private static HttpClientOptions createHttpClientOptions() {
        HttpClientOptions httpClientOptions = new HttpClientOptions();
        httpClientOptions.setMaxPoolSize(TransportClientConfig.getConnectionMaxPoolSize());
        httpClientOptions.setIdleTimeout(TransportClientConfig.getConnectionIdleTimeoutInSeconds());
        httpClientOptions.setKeepAlive(TransportClientConfig.getConnectionKeepAlive());
        httpClientOptions.setTryUseCompression(TransportClientConfig.getConnectionCompression());
        VertxTLSBuilder.buildHttpClientOptions((String)SSL_KEY, (HttpClientOptions)httpClientOptions);
        return httpClientOptions;
    }

    public void send(Invocation invocation, AsyncResponse asyncResp) {
        URIEndpointObject endpoint = (URIEndpointObject)invocation.getEndpoint().getAddress();
        HttpClientWithContext httpClientWithContext = endpoint.isHttp2Enabled() ? this.findHttp2ClientPool(invocation) : this.findHttpClientPool(invocation);
        RestClientInvocation restClientInvocation = new RestClientInvocation(httpClientWithContext, this.httpClientFilters);
        try {
            restClientInvocation.invoke(invocation, asyncResp);
        }
        catch (Throwable e) {
            asyncResp.fail(invocation.getInvocationType(), e);
            LOGGER.error("vertx rest transport send error.", e);
        }
    }

    protected HttpClientWithContext findHttpClientPool(Invocation invocation) {
        return (HttpClientWithContext)this.clientMgr.findClientPool(invocation.isSync());
    }

    public HttpClientWithContext findHttp2ClientPool(Invocation invocation) {
        return (HttpClientWithContext)this.clientMgrHttp2.findClientPool(invocation.isSync());
    }
}

