/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.client.http;

import java.util.Collection;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.common.rest.codec.produce.ProduceProcessor;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.common.rest.filter.HttpClientFilter;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.ExceptionFactory;
import org.apache.servicecomb.swagger.invocation.response.ResponseMeta;

public class DefaultHttpClientFilter
implements HttpClientFilter {
    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void beforeSendRequest(Invocation invocation, HttpServletRequestEx requestEx) {
    }

    protected ProduceProcessor findProduceProcessor(RestOperationMeta restOperation, HttpServletResponseEx responseEx) {
        String contentType = responseEx.getHeader("Content-Type");
        if (contentType == null) {
            return null;
        }
        String contentTypeForFind = contentType;
        int idx = contentType.indexOf(59);
        if (idx != -1) {
            contentTypeForFind = contentType.substring(0, idx);
        }
        return restOperation.findProduceProcessor(contentTypeForFind);
    }

    protected Object extractResult(Invocation invocation, HttpServletResponseEx responseEx) {
        Object result = invocation.getHandlerContext().get("servicecomb-readStreamPart");
        if (result != null) {
            return result;
        }
        OperationMeta operationMeta = invocation.getOperationMeta();
        ResponseMeta responseMeta = operationMeta.findResponseMeta(responseEx.getStatus());
        RestOperationMeta swaggerRestOperation = (RestOperationMeta)operationMeta.getExtData("swaggerRestOperation");
        ProduceProcessor produceProcessor = this.findProduceProcessor(swaggerRestOperation, responseEx);
        if (produceProcessor == null) {
            String msg = String.format("method %s, path %s, statusCode %d, reasonPhrase %s, response content-type %s is not supported", swaggerRestOperation.getHttpMethod(), swaggerRestOperation.getAbsolutePath(), responseEx.getStatus(), responseEx.getStatusType().getReasonPhrase(), responseEx.getHeader("Content-Type"));
            return ExceptionFactory.createConsumerException((Object)new CommonExceptionData(msg));
        }
        try {
            return produceProcessor.decodeResponse(responseEx.getBodyBuffer(), responseMeta.getJavaType());
        }
        catch (Exception e) {
            return ExceptionFactory.createConsumerException((Object)e);
        }
    }

    public Response afterReceiveResponse(Invocation invocation, HttpServletResponseEx responseEx) {
        Object result = this.extractResult(invocation, responseEx);
        Response response = Response.create((Response.StatusType)responseEx.getStatusType(), (Object)result);
        for (String headerName : responseEx.getHeaderNames()) {
            Collection headerValues = responseEx.getHeaders(headerName);
            for (String headerValue : headerValues) {
                response.getHeaders().addHeader(headerName, (Object)headerValue);
            }
        }
        return response;
    }
}

