/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.client.http;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import java.util.List;
import javax.servlet.http.Part;
import org.apache.servicecomb.common.rest.codec.param.RestClientRequestImpl;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.common.rest.filter.HttpClientFilter;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.transport.AbstractTransport;
import org.apache.servicecomb.foundation.common.http.HttpStatus;
import org.apache.servicecomb.foundation.common.net.IpPort;
import org.apache.servicecomb.foundation.common.net.URIEndpointObject;
import org.apache.servicecomb.foundation.common.utils.JsonUtils;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClientWithContext;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.apache.servicecomb.foundation.vertx.http.ReadStreamPart;
import org.apache.servicecomb.foundation.vertx.http.VertxClientRequestToHttpServletRequest;
import org.apache.servicecomb.foundation.vertx.http.VertxClientResponseToHttpServletResponse;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.swagger.invocation.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class RestClientInvocation {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestClientInvocation.class);
    private HttpClientWithContext httpClientWithContext;
    private Invocation invocation;
    private AsyncResponse asyncResp;
    private List<HttpClientFilter> httpClientFilters;
    private HttpClientRequest clientRequest;
    private HttpClientResponse clientResponse;

    public RestClientInvocation(HttpClientWithContext httpClientWithContext, List<HttpClientFilter> httpClientFilters) {
        this.httpClientWithContext = httpClientWithContext;
        this.httpClientFilters = httpClientFilters;
    }

    public void invoke(Invocation invocation, AsyncResponse asyncResp) throws Exception {
        this.invocation = invocation;
        this.asyncResp = asyncResp;
        OperationMeta operationMeta = invocation.getOperationMeta();
        RestOperationMeta swaggerRestOperation = (RestOperationMeta)operationMeta.getExtData("swaggerRestOperation");
        String path = this.createRequestPath(swaggerRestOperation);
        IpPort ipPort = (IpPort)invocation.getEndpoint().getAddress();
        this.createRequest(ipPort, path);
        this.clientRequest.putHeader("x-cse-target-microservice", invocation.getMicroserviceName());
        RestClientRequestImpl restClientRequest = new RestClientRequestImpl(this.clientRequest, this.httpClientWithContext.context(), asyncResp);
        invocation.getHandlerContext().put("servicecomb-invocation-hanlder-requestclient", restClientRequest);
        Buffer requestBodyBuffer = restClientRequest.getBodyBuffer();
        VertxClientRequestToHttpServletRequest requestEx = new VertxClientRequestToHttpServletRequest(this.clientRequest, requestBodyBuffer);
        for (HttpClientFilter filter : this.httpClientFilters) {
            filter.beforeSendRequest(invocation, (HttpServletRequestEx)requestEx);
        }
        this.clientRequest.exceptionHandler(e -> {
            LOGGER.error("Failed to send request to {}.", (Object)ipPort.getSocketAddress(), e);
            asyncResp.fail(invocation.getInvocationType(), e);
        });
        this.clientRequest.connectionHandler(connection -> {
            LOGGER.debug("http connection connected, local:{}, remote:{}.", (Object)connection.localAddress(), (Object)connection.remoteAddress());
            connection.closeHandler(v -> LOGGER.debug("http connection closed, local:{}, remote:{}.", (Object)connection.localAddress(), (Object)connection.remoteAddress()));
            connection.exceptionHandler(e -> LOGGER.info("http connection exception, local:{}, remote:{}.", new Object[]{connection.localAddress(), connection.remoteAddress(), e}));
        });
        this.httpClientWithContext.runOnContext(httpClient -> {
            this.setCseContext();
            this.clientRequest.setTimeout(AbstractTransport.getReqTimeout((String)invocation.getOperationName(), (String)invocation.getSchemaId(), (String)invocation.getMicroserviceName()));
            try {
                restClientRequest.end();
            }
            catch (Throwable e) {
                LOGGER.error("send http request failed,", e);
                asyncResp.fail(invocation.getInvocationType(), e);
            }
        });
    }

    private HttpMethod getMethod() {
        OperationMeta operationMeta = this.invocation.getOperationMeta();
        RestOperationMeta swaggerRestOperation = (RestOperationMeta)operationMeta.getExtData("swaggerRestOperation");
        String method = swaggerRestOperation.getHttpMethod();
        return HttpMethod.valueOf((String)method);
    }

    void createRequest(IpPort ipPort, String path) {
        URIEndpointObject endpoint = (URIEndpointObject)this.invocation.getEndpoint().getAddress();
        RequestOptions requestOptions = new RequestOptions();
        requestOptions.setHost(ipPort.getHostOrIp()).setPort(ipPort.getPort()).setSsl(endpoint.isSslEnabled()).setURI(path);
        HttpMethod method = this.getMethod();
        LOGGER.debug("Sending request by rest, method={}, qualifiedName={}, path={}, endpoint={}.", new Object[]{method, this.invocation.getMicroserviceQualifiedName(), path, this.invocation.getEndpoint().getEndpoint()});
        this.clientRequest = this.httpClientWithContext.getHttpClient().request(method, requestOptions, this::handleResponse);
    }

    protected void handleResponse(HttpClientResponse httpClientResponse) {
        this.clientResponse = httpClientResponse;
        if (HttpStatus.isSuccess((int)this.clientResponse.statusCode()) && Part.class.equals(this.invocation.getOperationMeta().getMethod().getReturnType())) {
            ReadStreamPart part = new ReadStreamPart(this.httpClientWithContext.context(), httpClientResponse);
            this.invocation.getHandlerContext().put("servicecomb-readStreamPart", part);
            this.processResponseBody(null);
            return;
        }
        httpClientResponse.exceptionHandler(e -> {
            LOGGER.error("Failed to receive response from {}.", (Object)httpClientResponse.netSocket().remoteAddress(), e);
            this.asyncResp.fail(this.invocation.getInvocationType(), e);
        });
        this.clientResponse.bodyHandler(responseBuf -> this.processResponseBody((Buffer)responseBuf));
    }

    protected void processResponseBody(Buffer responseBuf) {
        this.invocation.getResponseExecutor().execute(() -> {
            try {
                VertxClientResponseToHttpServletResponse responseEx = new VertxClientResponseToHttpServletResponse(this.clientResponse, responseBuf);
                for (HttpClientFilter filter : this.httpClientFilters) {
                    Response response = filter.afterReceiveResponse(this.invocation, (HttpServletResponseEx)responseEx);
                    if (response == null) continue;
                    this.asyncResp.complete(response);
                    return;
                }
            }
            catch (Throwable e) {
                this.asyncResp.fail(this.invocation.getInvocationType(), e);
            }
        });
    }

    protected void setCseContext() {
        try {
            String cseContext = JsonUtils.writeValueAsString((Object)this.invocation.getContext());
            this.clientRequest.putHeader("x-cse-context", cseContext);
        }
        catch (Exception e) {
            LOGGER.debug("Failed to encode and set cseContext.", (Throwable)e);
        }
    }

    protected String createRequestPath(RestOperationMeta swaggerRestOperation) throws Exception {
        URIEndpointObject address = (URIEndpointObject)this.invocation.getEndpoint().getAddress();
        String urlPrefix = address.getFirst("urlPrefix");
        String path = (String)this.invocation.getHandlerContext().get("rest-client-request-path");
        if (path == null) {
            path = swaggerRestOperation.getPathBuilder().createRequestPath(this.invocation.getArgs());
        }
        if (StringUtils.isEmpty((Object)urlPrefix) || path.startsWith(urlPrefix)) {
            return path;
        }
        return urlPrefix + path;
    }
}

