/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.servlet;

import java.util.Arrays;
import java.util.LinkedHashSet;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.transport.rest.servlet.RestServletInjector;
import org.apache.servicecomb.transport.rest.servlet.ServletUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class CseXmlWebApplicationContext
extends XmlWebApplicationContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(CseXmlWebApplicationContext.class);
    static final String KEY_LOCATION = "contextConfigLocation";
    private String defaultBeanResource = "classpath*:META-INF/spring/*.bean.xml";

    public CseXmlWebApplicationContext() {
    }

    public CseXmlWebApplicationContext(ServletContext servletContext) {
        this.setServletContext(servletContext);
    }

    public void setDefaultBeanResource(String defaultBeanResource) {
        this.defaultBeanResource = defaultBeanResource;
    }

    protected void invokeBeanFactoryPostProcessors(ConfigurableListableBeanFactory beanFactory) {
        super.invokeBeanFactoryPostProcessors(beanFactory);
        RestServletInjector.defaultInject(this.getServletContext());
        ServletUtils.saveUrlPrefix(this.getServletContext());
    }

    public String[] getConfigLocations() {
        String contextConfigLocation = this.getServletContext().getInitParameter(KEY_LOCATION);
        Object[] locationArray = this.splitLocations(contextConfigLocation);
        LOGGER.info("init spring context: {}.", (Object)Arrays.toString(locationArray));
        return locationArray;
    }

    private String[] splitLocations(String locations) {
        LinkedHashSet<String> locationSet = new LinkedHashSet<String>();
        if (!StringUtils.isEmpty((CharSequence)locations)) {
            for (String location : locations.split("[,\n]")) {
                if (StringUtils.isEmpty((CharSequence)(location = location.trim()))) continue;
                locationSet.add(location);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)this.defaultBeanResource)) {
            locationSet.add(this.defaultBeanResource);
        }
        return locationSet.toArray(new String[locationSet.size()]);
    }
}

