/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.servlet;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import org.apache.servicecomb.foundation.common.exceptions.ServiceCombException;
import org.apache.servicecomb.foundation.common.net.IpPort;
import org.apache.servicecomb.foundation.common.net.NetUtils;
import org.apache.servicecomb.transport.rest.servlet.RestServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ServletUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletUtils.class);

    public static boolean canPublishEndpoint(String listenAddress) {
        if (StringUtils.isEmpty((Object)listenAddress)) {
            LOGGER.info("listenAddress is null, can not publish.");
            return false;
        }
        IpPort ipPort = NetUtils.parseIpPortFromURI((String)("http://" + listenAddress));
        if (ipPort == null) {
            LOGGER.info("invalid listenAddress {}, can not publish, format should be ip:port.", (Object)listenAddress);
            return false;
        }
        if (NetUtils.canTcpListen((InetAddress)ipPort.getSocketAddress().getAddress(), (int)ipPort.getPort())) {
            LOGGER.info("{} is not listened, can not publish.", (Object)ipPort.getSocketAddress());
            return false;
        }
        return true;
    }

    static void checkUrlPattern(String urlPattern) {
        if (!urlPattern.startsWith("/")) {
            throw new ServiceCombException("only support rule like /* or /path/* or /path1/path2/* and so on.");
        }
        int idx = urlPattern.indexOf("/*");
        if (idx < 0 || idx >= 0 && idx != urlPattern.length() - 2) {
            throw new ServiceCombException("only support rule like /* or /path/* or /path1/path2/* and so on.");
        }
    }

    static String[] filterUrlPatterns(String ... urlPatterns) {
        return ServletUtils.filterUrlPatterns(Arrays.asList(urlPatterns));
    }

    static String[] filterUrlPatterns(Collection<String> urlPatterns) {
        return (String[])urlPatterns.stream().filter(pattern -> !pattern.trim().isEmpty()).filter(pattern -> {
            ServletUtils.checkUrlPattern(pattern.trim());
            return true;
        }).toArray(String[]::new);
    }

    static String[] collectUrlPatterns(ServletContext servletContext, Class<?> servletCls) {
        List servlets = servletContext.getServletRegistrations().values().stream().filter(predicate -> predicate.getClassName().equals(servletCls.getName())).collect(Collectors.toList());
        if (servlets.isEmpty()) {
            return new String[0];
        }
        ServletRegistration servletRegistration = (ServletRegistration)servlets.get(0);
        Collection mappings = servletRegistration.getMappings();
        if (servlets.size() > 1) {
            LOGGER.info("Found {} {} registered, select the first one, mappings={}.", new Object[]{servlets.size(), servletCls.getName(), mappings});
        }
        return ServletUtils.filterUrlPatterns(mappings);
    }

    static String collectUrlPrefix(ServletContext servletContext, Class<?> servletCls) {
        String[] urlPatterns = ServletUtils.collectUrlPatterns(servletContext, servletCls);
        if (urlPatterns.length == 0) {
            return null;
        }
        String urlPattern = urlPatterns[0];
        return servletContext.getContextPath() + urlPattern.substring(0, urlPattern.length() - 2);
    }

    public static void saveUrlPrefix(ServletContext servletContext) {
        String urlPrefix = ServletUtils.collectUrlPrefix(servletContext, RestServlet.class);
        if (urlPrefix == null) {
            LOGGER.info("RestServlet not found, will not save UrlPrefix.");
            return;
        }
        System.setProperty("urlPrefix", urlPrefix);
        LOGGER.info("UrlPrefix of this instance is \"{}\".", (Object)urlPrefix);
    }
}

