/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.servlet;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.servicecomb.foundation.common.utils.JsonUtils;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestAsyncListener
implements AsyncListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestAsyncListener.class);
    private static String TIMEOUT_MESSAGE;

    public void onComplete(AsyncEvent event) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTimeout(AsyncEvent event) throws IOException {
        HttpServletRequestEx requestEx;
        ServletRequest request = event.getSuppliedRequest();
        HttpServletRequestEx httpServletRequestEx = requestEx = (HttpServletRequestEx)request.getAttribute("servicecomb-rest-request");
        synchronized (httpServletRequestEx) {
            ServletResponse response = event.getAsyncContext().getResponse();
            if (!response.isCommitted()) {
                LOGGER.error("Rest request timeout, method {}, path {}.", (Object)requestEx.getMethod(), (Object)requestEx.getRequestURI());
                response.setContentType("application/json");
                ((HttpServletResponse)response).setStatus(590);
                PrintWriter out = response.getWriter();
                out.write(TIMEOUT_MESSAGE);
                response.flushBuffer();
            }
            request.removeAttribute("servicecomb-rest-request");
        }
    }

    public void onError(AsyncEvent event) throws IOException {
    }

    public void onStartAsync(AsyncEvent event) throws IOException {
    }

    static {
        try {
            TIMEOUT_MESSAGE = JsonUtils.writeValueAsString((Object)new CommonExceptionData("TimeOut in Processing"));
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Failed to init timeout message.", (Throwable)e);
        }
    }
}

