/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.vertx;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.net.NetServerOptions;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.CorsHandler;
import java.util.List;
import java.util.Set;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.foundation.common.net.URIEndpointObject;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.foundation.ssl.SSLCustom;
import org.apache.servicecomb.foundation.ssl.SSLOption;
import org.apache.servicecomb.foundation.ssl.SSLOptionFactory;
import org.apache.servicecomb.foundation.vertx.VertxTLSBuilder;
import org.apache.servicecomb.transport.rest.vertx.TransportConfig;
import org.apache.servicecomb.transport.rest.vertx.VertxHttpDispatcher;
import org.apache.servicecomb.transport.rest.vertx.accesslog.AccessLogConfiguration;
import org.apache.servicecomb.transport.rest.vertx.accesslog.impl.AccessLogHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestServerVerticle
extends AbstractVerticle {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestServerVerticle.class);
    private static final String SSL_KEY = "rest.provider";
    private Endpoint endpoint;
    private URIEndpointObject endpointObject;

    public void init(Vertx vertx, Context context) {
        super.init(vertx, context);
        this.endpoint = (Endpoint)context.config().getValue("servicecomb.endpoint");
        this.endpointObject = (URIEndpointObject)this.endpoint.getAddress();
    }

    public void start(Future<Void> startFuture) throws Exception {
        try {
            super.start();
            if (this.endpointObject == null) {
                LOGGER.warn("rest listen address is not configured, will not start.");
                startFuture.complete();
                return;
            }
            Router mainRouter = Router.router((Vertx)this.vertx);
            this.mountAccessLogHandler(mainRouter);
            this.mountCorsHandler(mainRouter);
            this.initDispatcher(mainRouter);
            HttpServer httpServer = this.createHttpServer();
            httpServer.requestHandler(arg_0 -> ((Router)mainRouter).accept(arg_0));
            this.startListen(httpServer, startFuture);
        }
        catch (Throwable e) {
            LOGGER.error("", e);
            throw e;
        }
    }

    private void mountAccessLogHandler(Router mainRouter) {
        if (AccessLogConfiguration.INSTANCE.getAccessLogEnabled()) {
            String pattern = AccessLogConfiguration.INSTANCE.getAccesslogPattern();
            LOGGER.info("access log enabled, pattern = {}", (Object)pattern);
            mainRouter.route().handler((Handler)new AccessLogHandler(pattern));
        }
    }

    void mountCorsHandler(Router mainRouter) {
        if (!TransportConfig.isCorsEnabled()) {
            return;
        }
        CorsHandler corsHandler = this.getCorsHandler(TransportConfig.getCorsAllowedOrigin());
        corsHandler.allowCredentials(TransportConfig.isCorsAllowCredentials());
        corsHandler.allowedHeaders(TransportConfig.getCorsAllowedHeaders());
        Set<String> allowedMethods = TransportConfig.getCorsAllowedMethods();
        for (String method : allowedMethods) {
            corsHandler.allowedMethod(HttpMethod.valueOf((String)method));
        }
        corsHandler.exposedHeaders(TransportConfig.getCorsExposedHeaders());
        int maxAge = TransportConfig.getCorsMaxAge();
        if (maxAge >= 0) {
            corsHandler.maxAgeSeconds(maxAge);
        }
        LOGGER.info("mount CorsHandler");
        mainRouter.route().handler((Handler)corsHandler);
    }

    private CorsHandler getCorsHandler(String corsAllowedOrigin) {
        return CorsHandler.create((String)corsAllowedOrigin);
    }

    private void initDispatcher(Router mainRouter) {
        List dispatchers = SPIServiceUtils.getSortedService(VertxHttpDispatcher.class);
        for (VertxHttpDispatcher dispatcher : dispatchers) {
            if (!dispatcher.enabled()) continue;
            dispatcher.init(mainRouter);
        }
    }

    private void startListen(HttpServer server, Future<Void> startFuture) {
        server.listen(this.endpointObject.getPort(), this.endpointObject.getHostOrIp(), ar -> {
            if (ar.succeeded()) {
                LOGGER.info("rest listen success. address={}:{}", (Object)this.endpointObject.getHostOrIp(), (Object)((HttpServer)ar.result()).actualPort());
                startFuture.complete();
                return;
            }
            String msg = String.format("rest listen failed, address=%s:%d", this.endpointObject.getHostOrIp(), this.endpointObject.getPort());
            LOGGER.error(msg, ar.cause());
            startFuture.fail(ar.cause());
        });
    }

    private HttpServer createHttpServer() {
        HttpServerOptions serverOptions = this.createDefaultHttpServerOptions();
        return this.vertx.createHttpServer(serverOptions);
    }

    private HttpServerOptions createDefaultHttpServerOptions() {
        HttpServerOptions serverOptions = new HttpServerOptions();
        serverOptions.setUsePooledBuffers(true);
        serverOptions.setIdleTimeout(TransportConfig.getConnectionIdleTimeoutInSeconds());
        serverOptions.setCompressionSupported(TransportConfig.getCompressed());
        serverOptions.setMaxHeaderSize(TransportConfig.getMaxHeaderSize());
        if (this.endpointObject.isHttp2Enabled()) {
            serverOptions.setUseAlpn(true);
        }
        if (this.endpointObject.isSslEnabled()) {
            SSLOptionFactory factory = SSLOptionFactory.createSSLOptionFactory((String)SSL_KEY, null);
            SSLOption sslOption = factory == null ? SSLOption.buildFromYaml((String)SSL_KEY) : factory.createSSLOption();
            SSLCustom sslCustom = SSLCustom.createSSLCustom((String)sslOption.getSslCustomClass());
            VertxTLSBuilder.buildNetServerOptions((SSLOption)sslOption, (SSLCustom)sslCustom, (NetServerOptions)serverOptions);
        }
        return serverOptions;
    }
}

