/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.vertx.accesslog;

import io.vertx.ext.web.RoutingContext;
import java.util.List;
import org.apache.servicecomb.transport.rest.vertx.accesslog.AccessLogParam;
import org.apache.servicecomb.transport.rest.vertx.accesslog.element.AccessLogItem;
import org.apache.servicecomb.transport.rest.vertx.accesslog.parser.AccessLogPatternParser;
import org.apache.servicecomb.transport.rest.vertx.accesslog.parser.impl.VertxRestAccessLogPatternParser;

public class AccessLogGenerator {
    private AccessLogItem<RoutingContext>[] accessLogItems;
    private AccessLogPatternParser<RoutingContext> accessLogPatternParser = new VertxRestAccessLogPatternParser();

    public AccessLogGenerator(String rawPattern) {
        List<AccessLogItem<RoutingContext>> accessLogItemList = this.accessLogPatternParser.parsePattern(rawPattern);
        this.accessLogItems = accessLogItemList.toArray(new AccessLogItem[0]);
    }

    public String generateLog(AccessLogParam<RoutingContext> accessLogParam) {
        StringBuilder log = new StringBuilder(128);
        accessLogParam.setEndMillisecond(System.currentTimeMillis());
        AccessLogItem<RoutingContext>[] accessLogItems = this.getAccessLogItems();
        for (int i = 0; i < accessLogItems.length; ++i) {
            log.append(accessLogItems[i].getFormattedItem(accessLogParam));
        }
        return log.toString();
    }

    private AccessLogItem<RoutingContext>[] getAccessLogItems() {
        return this.accessLogItems;
    }
}

