/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.naming;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collections;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.servicemix.naming.ProxyInvocationHandler;
import org.apache.xbean.naming.context.ImmutableContext;
import org.osgi.framework.BundleContext;

public class OSGiServicesContext
extends ImmutableContext {
    private BundleContext bundleContext;

    public OSGiServicesContext(BundleContext bundleContext) throws NamingException {
        super(Collections.<String, Object>emptyMap());
        this.bundleContext = bundleContext;
    }

    public Object lookup(String name) throws NamingException {
        String[] parts = name.split("/");
        if (parts.length == 0 || parts.length > 2) {
            throw new NameNotFoundException("Unrecognized name, should be osgi:services:<interface>[/<filter>]");
        }
        String className = parts[0];
        String filter = parts.length == 2 ? parts[1] : null;
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            Class<?> clazz = classLoader.loadClass(className);
            String clazzFilter = "(objectClass=" + clazz.getName() + ")";
            filter = filter == null ? clazzFilter : (filter.startsWith("(") ? "(&" + clazzFilter + filter + ")" : "(&" + clazzFilter + "(" + filter + "))");
            ProxyInvocationHandler handler = new ProxyInvocationHandler(this.bundleContext, filter);
            handler.getTarget(false);
            Object instance = Proxy.newProxyInstance(classLoader, new Class[]{clazz}, (InvocationHandler)handler);
            return instance;
        }
        catch (Exception e) {
            NameNotFoundException ex = new NameNotFoundException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }
}

