/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common.osgi;

import org.apache.servicemix.executors.impl.ExecutorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private final Logger logger = LoggerFactory.getLogger(Configuration.class);
    private static final Configuration INSTANCE = new Configuration();
    private final ExecutorConfig executorConfig = new ExecutorConfig();

    private Configuration() {
        this.logger.debug("Configuring JBI components using OSGi ConfigAdmin");
    }

    public static final Configuration getInstance() {
        return INSTANCE;
    }

    public void setCorePoolSize(int size) {
        this.logger.debug("Setting core thread pool size: {}", (Object)size);
        this.executorConfig.setCorePoolSize(Integer.valueOf(size));
    }

    public void setMaximumPoolSize(int size) {
        this.logger.debug("Setting maximum thread pool size: {}", (Object)size);
        this.executorConfig.setMaximumPoolSize(Integer.valueOf(size));
    }

    public void setQueueSize(int size) {
        this.logger.debug("Setting executor queue size: {}", (Object)size);
        this.executorConfig.setQueueSize(Integer.valueOf(size));
    }

    public void setAllowCoreThreadTimeOut(boolean timeout) {
        this.logger.debug("Setting core thread timeout allow: {}", (Object)timeout);
        this.executorConfig.setAllowCoreThreadTimeOut(Boolean.valueOf(timeout));
    }

    public void setKeepAliveTime(long time) {
        this.logger.debug("Setting thread keep-alive time: {}", (Object)time);
        this.executorConfig.setKeepAliveTime(Long.valueOf(time));
    }

    public ExecutorConfig getExecutorConfig() {
        return this.executorConfig;
    }
}

