/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.saxon;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.parsers.DocumentBuilder;
import net.sf.saxon.Configuration;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.apache.servicemix.expression.Expression;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.w3c.dom.Document;

public abstract class SaxonEndpoint
extends ProviderEndpoint {
    public static final String RESULT_BYTES = "bytes";
    public static final String RESULT_STRING = "string";
    public static final String RESULT_DOM = "dom";
    private Configuration configuration;
    private boolean copyProperties = true;
    private boolean copyAttachments = true;
    private boolean copySubject = true;
    private String result = "dom";
    private Resource resource;
    private boolean reload;
    private Expression expression;
    private Resource wsdlResource;
    private SourceTransformer sourceTransformer = new SourceTransformer();
    private Map parameters;

    protected void setSourceTransformer(SourceTransformer sourceTransformer) {
        this.sourceTransformer = sourceTransformer;
    }

    public SourceTransformer getSourceTransformer() {
        return this.sourceTransformer;
    }

    public Resource getWsdlResource() {
        return this.wsdlResource;
    }

    public void setWsdlResource(Resource wsdlResource) {
        this.wsdlResource = wsdlResource;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public boolean isReload() {
        return this.reload;
    }

    public void setReload(boolean reload) {
        this.reload = reload;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public boolean isCopyAttachments() {
        return this.copyAttachments;
    }

    public void setCopyAttachments(boolean copyAttachments) {
        this.copyAttachments = copyAttachments;
    }

    public boolean isCopyProperties() {
        return this.copyProperties;
    }

    public void setCopyProperties(boolean copyProperties) {
        this.copyProperties = copyProperties;
    }

    public boolean isCopySubject() {
        return this.copySubject;
    }

    public void setCopySubject(boolean copySubject) {
        this.copySubject = copySubject;
    }

    public Map getParameters() {
        return this.parameters;
    }

    public void setParameters(Map parameters) {
        this.parameters = parameters;
    }

    public void activate() throws Exception {
        if (this.wsdlResource != null) {
            this.setDescription(this.parse(this.wsdlResource));
        }
        super.activate();
    }

    protected void processInOut(MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws Exception {
        this.copyPropertiesAndAttachments(in, out);
        this.transform(exchange, in, out);
    }

    protected void copyPropertiesAndAttachments(NormalizedMessage source, NormalizedMessage dest) throws Exception {
        if (this.isCopyProperties()) {
            for (String name : source.getPropertyNames()) {
                dest.setProperty(name, source.getProperty(name));
            }
        }
        if (this.isCopyAttachments()) {
            for (String name : source.getAttachmentNames()) {
                dest.addAttachment(name, source.getAttachment(name));
            }
        }
        if (this.isCopySubject()) {
            dest.setSecuritySubject(source.getSecuritySubject());
        }
    }

    protected abstract void transform(MessageExchange var1, NormalizedMessage var2, NormalizedMessage var3) throws Exception;

    protected Resource getDynamicResource(MessageExchange exchange, NormalizedMessage in) throws Exception {
        Object res = this.getExpression().evaluate(exchange, in);
        if (res == null) {
            return null;
        }
        if (res instanceof Resource) {
            return (Resource)res;
        }
        if (res instanceof File) {
            return new FileSystemResource((File)res);
        }
        if (res instanceof URL) {
            return new UrlResource((URL)res);
        }
        if (res instanceof URI) {
            return new UrlResource(((URI)res).toURL());
        }
        return new DefaultResourceLoader().getResource(res.toString());
    }

    protected Document parse(Resource res) throws Exception {
        URL url = null;
        try {
            url = res.getURL();
        }
        catch (IOException e) {
            // empty catch block
        }
        DocumentBuilder builder = this.sourceTransformer.createDocumentBuilder();
        return builder.parse(res.getInputStream(), url != null ? url.toExternalForm() : null);
    }
}

