/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.saxon;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;
import java.util.Properties;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.trans.XPathException;
import org.apache.servicemix.jbi.jaxp.BytesSource;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.servicemix.saxon.SaxonEndpoint;
import org.springframework.core.io.Resource;

public class XQueryEndpoint
extends SaxonEndpoint {
    private static final Properties EMPTY_PROPS = new Properties();
    private String query;
    private XQueryExpression exp;
    private StaticQueryContext staticEnv;
    private Properties outputProperties;

    public Properties getOutputProperties() {
        return this.outputProperties;
    }

    public void setOutputProperties(Properties outputProperties) {
        this.outputProperties = outputProperties;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void start() throws Exception {
        super.start();
        Configuration config = this.getConfiguration();
        if (config == null) {
            config = new Configuration();
        }
        config.setHostLanguage(51);
        this.setConfiguration(config);
        this.staticEnv = new StaticQueryContext(config);
        this.exp = this.compileQuery();
    }

    public void validate() throws DeploymentException {
        if (this.getQuery() == null && this.getResource() == null && this.getExpression() == null) {
            throw new DeploymentException("query, resource or expression should be specified");
        }
    }

    protected void transform(MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws Exception {
        XQueryExpression expression = this.createQuery(exchange, in);
        this.queryContent(expression, exchange, in, out);
    }

    protected void queryContent(XQueryExpression expression, MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws Exception {
        Properties props;
        Configuration config = this.getConfiguration();
        DynamicQueryContext dynamicEnv = new DynamicQueryContext(config);
        DocumentInfo doc = this.staticEnv.buildDocument(in.getContent());
        dynamicEnv.setContextItem((Item)doc);
        this.configureQuery(dynamicEnv, exchange, in);
        Properties properties = props = this.outputProperties != null ? this.outputProperties : EMPTY_PROPS;
        if ("bytes".equalsIgnoreCase(this.getResult())) {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(buffer);
            expression.pull(dynamicEnv, (Result)result, props);
            out.setContent((Source)new BytesSource(buffer.toByteArray()));
        } else if ("string".equalsIgnoreCase(this.getResult())) {
            StringWriter buffer = new StringWriter();
            StreamResult result = new StreamResult(buffer);
            expression.pull(dynamicEnv, (Result)result, props);
            out.setContent((Source)new StringSource(buffer.toString()));
        } else {
            DOMResult result = new DOMResult();
            expression.pull(dynamicEnv, (Result)result, props);
            out.setContent((Source)new DOMSource(result.getNode()));
        }
    }

    protected void configureQuery(DynamicQueryContext dynamicEnv, MessageExchange exchange, NormalizedMessage in) throws Exception {
        Object value;
        for (String name : exchange.getPropertyNames()) {
            value = exchange.getProperty(name);
            dynamicEnv.setParameter(name, value);
        }
        for (String name : in.getPropertyNames()) {
            value = in.getProperty(name);
            dynamicEnv.setParameter(name, value);
        }
        Map parameters = this.getParameters();
        if (parameters != null) {
            for (String name : parameters.keySet()) {
                Object value2 = parameters.get(name);
                dynamicEnv.setParameter(name, value2);
            }
        }
        dynamicEnv.setParameter("exchange", (Object)exchange);
        dynamicEnv.setParameter("in", (Object)in);
        dynamicEnv.setParameter("component", (Object)this);
    }

    protected XQueryExpression createQuery(MessageExchange exchange, NormalizedMessage in) throws Exception {
        if (this.getExpression() != null) {
            Resource r = this.getDynamicResource(exchange, in);
            return this.staticEnv.compileQuery(r.getInputStream(), null);
        }
        if (this.isReload()) {
            return this.compileQuery();
        }
        return this.exp;
    }

    protected XQueryExpression compileQuery() throws XPathException, IOException {
        if (this.getQuery() != null) {
            return this.staticEnv.compileQuery(this.getQuery());
        }
        if (this.getResource() != null) {
            return this.staticEnv.compileQuery(this.getResource().getInputStream(), null);
        }
        return null;
    }
}

