/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.interceptors.jbi;

import java.net.URI;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.servicemix.soap.api.Message;
import org.apache.servicemix.soap.bindings.soap.SoapFault;
import org.apache.servicemix.soap.core.AbstractInterceptor;

public class JbiFaultOutInterceptor
extends AbstractInterceptor {
    public void handleMessage(Message message) {
        NormalizedMessage nm = message.getContent(NormalizedMessage.class);
        if (nm instanceof Fault) {
            SoapFault fault = this.createFault(nm);
            throw fault;
        }
    }

    private SoapFault createFault(NormalizedMessage nm) {
        Source src = nm.getContent();
        QName code = (QName)nm.getProperty("org.apache.servicemix.soap.fault.code");
        QName subcode = (QName)nm.getProperty("org.apache.servicemix.soap.fault.subcode");
        String reason = (String)nm.getProperty("org.apache.servicemix.soap.fault.reason");
        URI node = (URI)nm.getProperty("org.apache.servicemix.soap.fault.node");
        URI role = (URI)nm.getProperty("org.apache.servicemix.soap.fault.role");
        SoapFault fault = new SoapFault(code, subcode, reason, node, role, src);
        return fault;
    }
}

