/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.interceptors.xml;

import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.servicemix.soap.api.Fault;
import org.apache.servicemix.soap.api.Message;
import org.apache.servicemix.soap.core.AbstractInterceptor;
import org.apache.servicemix.soap.util.stax.DOMStreamReader;
import org.apache.servicemix.soap.util.stax.ExtendedXMLStreamReader;
import org.apache.servicemix.soap.util.stax.StaxUtil;
import org.w3c.dom.Document;

public class StaxInInterceptor
extends AbstractInterceptor {
    public static final String ENCODING = "Encoding";

    public void handleMessage(Message message) {
        try {
            XMLStreamReader reader;
            Document doc = message.getContent(Document.class);
            if (doc != null) {
                reader = new DOMStreamReader(doc.getDocumentElement());
            } else {
                InputStream is = message.getContent(InputStream.class);
                if (is != null) {
                    String encoding = (String)message.get(ENCODING);
                    reader = StaxUtil.createReader(is, encoding);
                    reader = new ExtendedXMLStreamReader(reader);
                } else {
                    return;
                }
            }
            reader.nextTag();
            message.setContent(XMLStreamReader.class, reader);
        }
        catch (XMLStreamException e) {
            throw new Fault(e);
        }
    }
}

