/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.instance;

import org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.shardingsphere.elasticjob.lite.internal.instance.InstanceNode;
import org.apache.shardingsphere.elasticjob.lite.internal.instance.InstanceService;
import org.apache.shardingsphere.elasticjob.lite.internal.listener.AbstractJobListener;
import org.apache.shardingsphere.elasticjob.lite.internal.listener.AbstractListenerManager;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.JobRegistry;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.SchedulerFacade;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;

public final class ShutdownListenerManager
extends AbstractListenerManager {
    private final String jobName;
    private final InstanceNode instanceNode;
    private final InstanceService instanceService;
    private final SchedulerFacade schedulerFacade;

    public ShutdownListenerManager(CoordinatorRegistryCenter regCenter, String jobName) {
        super(regCenter, jobName);
        this.jobName = jobName;
        this.instanceNode = new InstanceNode(jobName);
        this.instanceService = new InstanceService(regCenter, jobName);
        this.schedulerFacade = new SchedulerFacade(regCenter, jobName);
    }

    @Override
    public void start() {
        this.addDataListener(new InstanceShutdownStatusJobListener());
    }

    class InstanceShutdownStatusJobListener
    extends AbstractJobListener {
        InstanceShutdownStatusJobListener() {
        }

        @Override
        protected void dataChanged(String path, CuratorCacheListener.Type eventType, String data) {
            if (!JobRegistry.getInstance().isShutdown(ShutdownListenerManager.this.jobName) && !JobRegistry.getInstance().getJobScheduleController(ShutdownListenerManager.this.jobName).isPaused() && this.isRemoveInstance(path, eventType) && !this.isReconnectedRegistryCenter()) {
                ShutdownListenerManager.this.schedulerFacade.shutdownInstance();
            }
        }

        private boolean isRemoveInstance(String path, CuratorCacheListener.Type eventType) {
            return ShutdownListenerManager.this.instanceNode.isLocalInstancePath(path) && CuratorCacheListener.Type.NODE_DELETED == eventType;
        }

        private boolean isReconnectedRegistryCenter() {
            return ShutdownListenerManager.this.instanceService.isLocalJobInstanceExisted();
        }
    }
}

