/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.sharding;

import org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.infra.yaml.YamlEngine;
import org.apache.shardingsphere.elasticjob.lite.internal.config.ConfigurationNode;
import org.apache.shardingsphere.elasticjob.lite.internal.listener.AbstractJobListener;
import org.apache.shardingsphere.elasticjob.lite.internal.listener.AbstractListenerManager;
import org.apache.shardingsphere.elasticjob.lite.internal.sharding.ExecutionService;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;

public final class MonitorExecutionListenerManager
extends AbstractListenerManager {
    private final ExecutionService executionService;
    private final ConfigurationNode configNode;

    public MonitorExecutionListenerManager(CoordinatorRegistryCenter regCenter, String jobName) {
        super(regCenter, jobName);
        this.executionService = new ExecutionService(regCenter, jobName);
        this.configNode = new ConfigurationNode(jobName);
    }

    @Override
    public void start() {
        this.addDataListener(new MonitorExecutionSettingsChangedJobListener());
    }

    class MonitorExecutionSettingsChangedJobListener
    extends AbstractJobListener {
        MonitorExecutionSettingsChangedJobListener() {
        }

        @Override
        protected void dataChanged(String path, CuratorCacheListener.Type eventType, String data) {
            if (MonitorExecutionListenerManager.this.configNode.isConfigPath(path) && CuratorCacheListener.Type.NODE_CHANGED == eventType && !((JobConfigurationPOJO)YamlEngine.unmarshal((String)data, JobConfigurationPOJO.class)).toJobConfiguration().isMonitorExecution()) {
                MonitorExecutionListenerManager.this.executionService.clearAllRunningInfo();
            }
        }
    }
}

