/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.parameter.impl;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.aware.QueryWithCipherColumnAware;
import org.apache.shardingsphere.encrypt.rewrite.condition.EncryptCondition;
import org.apache.shardingsphere.encrypt.rewrite.condition.EncryptConditionEngine;
import org.apache.shardingsphere.encrypt.rewrite.parameter.EncryptParameterRewriter;
import org.apache.shardingsphere.sql.parser.binder.metadata.schema.SchemaMetaData;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.underlying.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.underlying.rewrite.parameter.builder.impl.StandardParameterBuilder;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.aware.SchemaMetaDataAware;

public final class EncryptPredicateParameterRewriter
extends EncryptParameterRewriter<SQLStatementContext>
implements SchemaMetaDataAware,
QueryWithCipherColumnAware {
    private SchemaMetaData schemaMetaData;
    private boolean queryWithCipherColumn;

    @Override
    protected boolean isNeedRewriteForEncrypt(SQLStatementContext sqlStatementContext) {
        return true;
    }

    public void rewrite(ParameterBuilder parameterBuilder, SQLStatementContext sqlStatementContext, List<Object> parameters) {
        List<EncryptCondition> encryptConditions = new EncryptConditionEngine(this.getEncryptRule(), this.schemaMetaData).createEncryptConditions(sqlStatementContext);
        if (encryptConditions.isEmpty()) {
            return;
        }
        for (EncryptCondition each : encryptConditions) {
            if (!this.queryWithCipherColumn) continue;
            this.encryptParameters(parameterBuilder, each.getPositionIndexMap(), this.getEncryptedValues(each, each.getValues(parameters)));
        }
    }

    private List<Object> getEncryptedValues(EncryptCondition encryptCondition, List<Object> originalValues) {
        String tableName = encryptCondition.getTableName();
        String columnName = encryptCondition.getColumnName();
        return this.getEncryptRule().findAssistedQueryColumn(tableName, columnName).isPresent() ? this.getEncryptRule().getEncryptAssistedQueryValues(tableName, columnName, originalValues) : this.getEncryptRule().getEncryptValues(tableName, columnName, originalValues);
    }

    private void encryptParameters(ParameterBuilder parameterBuilder, Map<Integer, Integer> positionIndexes, List<Object> encryptValues) {
        if (!positionIndexes.isEmpty()) {
            for (Map.Entry<Integer, Integer> entry : positionIndexes.entrySet()) {
                ((StandardParameterBuilder)parameterBuilder).addReplacedParameters(entry.getValue().intValue(), encryptValues.get(entry.getKey()));
            }
        }
    }

    @Generated
    public void setSchemaMetaData(SchemaMetaData schemaMetaData) {
        this.schemaMetaData = schemaMetaData;
    }

    @Override
    @Generated
    public void setQueryWithCipherColumn(boolean queryWithCipherColumn) {
        this.queryWithCipherColumn = queryWithCipherColumn;
    }
}

