/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.BaseEncryptSQLTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptAssignmentToken;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptLiteralAssignmentToken;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptParameterAssignmentToken;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.sql.parser.binder.statement.dml.UpdateStatementContext;
import org.apache.shardingsphere.sql.parser.binder.type.TableAvailable;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.UpdateStatement;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.CollectionSQLTokenGenerator;

public final class EncryptAssignmentTokenGenerator
extends BaseEncryptSQLTokenGenerator
implements CollectionSQLTokenGenerator {
    @Override
    protected boolean isGenerateSQLTokenForEncrypt(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof UpdateStatementContext || sqlStatementContext instanceof InsertStatementContext && ((InsertStatement)((InsertStatementContext)sqlStatementContext).getSqlStatement()).getSetAssignment().isPresent();
    }

    public Collection<EncryptAssignmentToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        LinkedList<EncryptAssignmentToken> result = new LinkedList<EncryptAssignmentToken>();
        String tableName = ((SimpleTableSegment)((TableAvailable)sqlStatementContext).getAllTables().iterator().next()).getTableName().getIdentifier().getValue();
        for (AssignmentSegment each : this.getSetAssignmentSegment(sqlStatementContext.getSqlStatement()).getAssignments()) {
            if (!this.getEncryptRule().findEncryptor(tableName, each.getColumn().getIdentifier().getValue()).isPresent()) continue;
            this.generateSQLToken(tableName, each).ifPresent(result::add);
        }
        return result;
    }

    private SetAssignmentSegment getSetAssignmentSegment(SQLStatement sqlStatement) {
        if (sqlStatement instanceof InsertStatement) {
            Optional result = ((InsertStatement)sqlStatement).getSetAssignment();
            Preconditions.checkState((boolean)result.isPresent());
            return (SetAssignmentSegment)result.get();
        }
        return ((UpdateStatement)sqlStatement).getSetAssignment();
    }

    private Optional<EncryptAssignmentToken> generateSQLToken(String tableName, AssignmentSegment assignmentSegment) {
        if (assignmentSegment.getValue() instanceof ParameterMarkerExpressionSegment) {
            return Optional.of(this.generateParameterSQLToken(tableName, assignmentSegment));
        }
        if (assignmentSegment.getValue() instanceof LiteralExpressionSegment) {
            return Optional.of(this.generateLiteralSQLToken(tableName, assignmentSegment));
        }
        return Optional.empty();
    }

    private EncryptAssignmentToken generateParameterSQLToken(String tableName, AssignmentSegment assignmentSegment) {
        EncryptParameterAssignmentToken result = new EncryptParameterAssignmentToken(assignmentSegment.getColumn().getStartIndex(), assignmentSegment.getStopIndex());
        String columnName = assignmentSegment.getColumn().getIdentifier().getValue();
        this.addCipherColumn(tableName, columnName, result);
        this.addAssistedQueryColumn(tableName, columnName, result);
        this.addPlainColumn(tableName, columnName, result);
        return result;
    }

    private void addCipherColumn(String tableName, String columnName, EncryptParameterAssignmentToken token) {
        token.addColumnName(this.getEncryptRule().getCipherColumn(tableName, columnName));
    }

    private void addAssistedQueryColumn(String tableName, String columnName, EncryptParameterAssignmentToken token) {
        this.getEncryptRule().findAssistedQueryColumn(tableName, columnName).ifPresent(token::addColumnName);
    }

    private void addPlainColumn(String tableName, String columnName, EncryptParameterAssignmentToken token) {
        this.getEncryptRule().findPlainColumn(tableName, columnName).ifPresent(token::addColumnName);
    }

    private EncryptAssignmentToken generateLiteralSQLToken(String tableName, AssignmentSegment assignmentSegment) {
        EncryptLiteralAssignmentToken result = new EncryptLiteralAssignmentToken(assignmentSegment.getColumn().getStartIndex(), assignmentSegment.getStopIndex());
        this.addCipherAssignment(tableName, assignmentSegment, result);
        this.addAssistedQueryAssignment(tableName, assignmentSegment, result);
        this.addPlainAssignment(tableName, assignmentSegment, result);
        return result;
    }

    private void addCipherAssignment(String tableName, AssignmentSegment assignmentSegment, EncryptLiteralAssignmentToken token) {
        Object originalValue = ((LiteralExpressionSegment)assignmentSegment.getValue()).getLiterals();
        Object cipherValue = this.getEncryptRule().getEncryptValues(tableName, assignmentSegment.getColumn().getIdentifier().getValue(), Collections.singletonList(originalValue)).iterator().next();
        token.addAssignment(this.getEncryptRule().getCipherColumn(tableName, assignmentSegment.getColumn().getIdentifier().getValue()), cipherValue);
    }

    private void addAssistedQueryAssignment(String tableName, AssignmentSegment assignmentSegment, EncryptLiteralAssignmentToken token) {
        Object originalValue = ((LiteralExpressionSegment)assignmentSegment.getValue()).getLiterals();
        Optional assistedQueryColumn = this.getEncryptRule().findAssistedQueryColumn(tableName, assignmentSegment.getColumn().getIdentifier().getValue());
        assistedQueryColumn.ifPresent(s -> {
            Object assistedQueryValue = this.getEncryptRule().getEncryptAssistedQueryValues(tableName, assignmentSegment.getColumn().getIdentifier().getValue(), Collections.singletonList(originalValue)).iterator().next();
            token.addAssignment((String)s, assistedQueryValue);
        });
    }

    private void addPlainAssignment(String tableName, AssignmentSegment assignmentSegment, EncryptLiteralAssignmentToken token) {
        Object originalValue = ((LiteralExpressionSegment)assignmentSegment.getValue()).getLiterals();
        this.getEncryptRule().findPlainColumn(tableName, assignmentSegment.getColumn().getIdentifier().getValue()).ifPresent(plainColumn -> token.addAssignment((String)plainColumn, originalValue));
    }
}

