/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.impl;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.BaseEncryptSQLTokenGenerator;
import org.apache.shardingsphere.encrypt.strategy.EncryptTable;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.column.InsertColumnsSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.OptionalSQLTokenGenerator;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.aware.PreviousSQLTokensAware;
import org.apache.shardingsphere.underlying.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.underlying.rewrite.sql.token.pojo.generic.UseDefaultInsertColumnsToken;

public final class EncryptForUseDefaultInsertColumnsTokenGenerator
extends BaseEncryptSQLTokenGenerator
implements OptionalSQLTokenGenerator<InsertStatementContext>,
PreviousSQLTokensAware {
    private List<SQLToken> previousSQLTokens;

    @Override
    protected boolean isGenerateSQLTokenForEncrypt(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof InsertStatementContext && ((InsertStatement)((InsertStatementContext)sqlStatementContext).getSqlStatement()).useDefaultColumns();
    }

    public UseDefaultInsertColumnsToken generateSQLToken(InsertStatementContext insertStatementContext) {
        String tableName = ((InsertStatement)insertStatementContext.getSqlStatement()).getTable().getTableName().getIdentifier().getValue();
        Optional<UseDefaultInsertColumnsToken> previousSQLToken = this.findInsertColumnsToken();
        if (previousSQLToken.isPresent()) {
            this.processPreviousSQLToken(previousSQLToken.get(), insertStatementContext, tableName);
            return previousSQLToken.get();
        }
        return this.generateNewSQLToken(insertStatementContext, tableName);
    }

    private Optional<UseDefaultInsertColumnsToken> findInsertColumnsToken() {
        for (SQLToken each : this.previousSQLTokens) {
            if (!(each instanceof UseDefaultInsertColumnsToken)) continue;
            return Optional.of((UseDefaultInsertColumnsToken)each);
        }
        return Optional.empty();
    }

    private void processPreviousSQLToken(UseDefaultInsertColumnsToken previousSQLToken, InsertStatementContext insertStatementContext, String tableName) {
        Optional encryptTable = this.getEncryptRule().findEncryptTable(tableName);
        Preconditions.checkState((boolean)encryptTable.isPresent());
        List<String> columnNames = this.getColumnNames(insertStatementContext, (EncryptTable)encryptTable.get(), previousSQLToken.getColumns());
        previousSQLToken.getColumns().clear();
        previousSQLToken.getColumns().addAll(columnNames);
    }

    private UseDefaultInsertColumnsToken generateNewSQLToken(InsertStatementContext insertStatementContext, String tableName) {
        Optional insertColumnsSegment = ((InsertStatement)insertStatementContext.getSqlStatement()).getInsertColumns();
        Preconditions.checkState((boolean)insertColumnsSegment.isPresent());
        Optional encryptTable = this.getEncryptRule().findEncryptTable(tableName);
        Preconditions.checkState((boolean)encryptTable.isPresent());
        return new UseDefaultInsertColumnsToken(((InsertColumnsSegment)insertColumnsSegment.get()).getStopIndex(), this.getColumnNames(insertStatementContext, (EncryptTable)encryptTable.get(), insertStatementContext.getColumnNames()));
    }

    private List<String> getColumnNames(InsertStatementContext sqlStatementContext, EncryptTable encryptTable, List<String> currentColumnNames) {
        LinkedList<String> result = new LinkedList<String>(currentColumnNames);
        Iterator descendingColumnNames = sqlStatementContext.getDescendingColumnNames();
        while (descendingColumnNames.hasNext()) {
            String columnName = (String)descendingColumnNames.next();
            if (!encryptTable.findEncryptor(columnName).isPresent()) continue;
            int columnIndex = result.indexOf(columnName);
            this.addPlainColumn(result, encryptTable, columnName, columnIndex);
            this.addAssistedQueryColumn(result, encryptTable, columnName, columnIndex);
            this.setCipherColumn(result, encryptTable, columnName, columnIndex);
        }
        return result;
    }

    private void addPlainColumn(List<String> columnNames, EncryptTable encryptTable, String columnName, int columnIndex) {
        encryptTable.findPlainColumn(columnName).ifPresent(plainColumn -> columnNames.add(columnIndex + 1, (String)plainColumn));
    }

    private void addAssistedQueryColumn(List<String> columnNames, EncryptTable encryptTable, String columnName, int columnIndex) {
        encryptTable.findAssistedQueryColumn(columnName).ifPresent(assistedQueryColumn -> columnNames.add(columnIndex + 1, (String)assistedQueryColumn));
    }

    private void setCipherColumn(List<String> columnNames, EncryptTable encryptTable, String columnName, int columnIndex) {
        columnNames.set(columnIndex, encryptTable.getCipherColumn(columnName));
    }

    @Generated
    public void setPreviousSQLTokens(List<SQLToken> previousSQLTokens) {
        this.previousSQLTokens = previousSQLTokens;
    }
}

