/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.BaseEncryptSQLTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptInsertValuesToken;
import org.apache.shardingsphere.encrypt.strategy.spi.Encryptor;
import org.apache.shardingsphere.encrypt.strategy.spi.QueryAssistedEncryptor;
import org.apache.shardingsphere.sql.parser.binder.segment.insert.values.InsertValueContext;
import org.apache.shardingsphere.sql.parser.binder.segment.insert.values.expression.DerivedLiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.binder.segment.insert.values.expression.DerivedParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.OptionalSQLTokenGenerator;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.aware.PreviousSQLTokensAware;
import org.apache.shardingsphere.underlying.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.underlying.rewrite.sql.token.pojo.generic.InsertValue;
import org.apache.shardingsphere.underlying.rewrite.sql.token.pojo.generic.InsertValuesToken;
import org.apache.shardingsphere.underlying.rewrite.sql.token.pojo.generic.UseDefaultInsertColumnsToken;

public final class EncryptInsertValuesTokenGenerator
extends BaseEncryptSQLTokenGenerator
implements OptionalSQLTokenGenerator<InsertStatementContext>,
PreviousSQLTokensAware {
    private List<SQLToken> previousSQLTokens;

    @Override
    protected boolean isGenerateSQLTokenForEncrypt(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof InsertStatementContext && !((InsertStatement)((InsertStatementContext)sqlStatementContext).getSqlStatement()).getValues().isEmpty();
    }

    public InsertValuesToken generateSQLToken(InsertStatementContext insertStatementContext) {
        Optional<SQLToken> insertValuesToken = this.findPreviousSQLToken(InsertValuesToken.class);
        if (insertValuesToken.isPresent()) {
            this.processPreviousSQLToken(insertStatementContext, (InsertValuesToken)insertValuesToken.get());
            return (InsertValuesToken)insertValuesToken.get();
        }
        return this.generateNewSQLToken(insertStatementContext);
    }

    private Optional<SQLToken> findPreviousSQLToken(Class<?> sqlToken) {
        for (SQLToken each : this.previousSQLTokens) {
            if (!sqlToken.isAssignableFrom(each.getClass())) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    private void processPreviousSQLToken(InsertStatementContext insertStatementContext, InsertValuesToken insertValuesToken) {
        String tableName = ((InsertStatement)insertStatementContext.getSqlStatement()).getTable().getTableName().getIdentifier().getValue();
        int count = 0;
        for (InsertValueContext each : insertStatementContext.getInsertValueContexts()) {
            this.encryptToken((InsertValue)insertValuesToken.getInsertValues().get(count), tableName, insertStatementContext, each);
            ++count;
        }
    }

    private InsertValuesToken generateNewSQLToken(InsertStatementContext insertStatementContext) {
        String tableName = ((InsertStatement)insertStatementContext.getSqlStatement()).getTable().getTableName().getIdentifier().getValue();
        Collection insertValuesSegments = ((InsertStatement)insertStatementContext.getSqlStatement()).getValues();
        EncryptInsertValuesToken result = new EncryptInsertValuesToken(this.getStartIndex(insertValuesSegments), this.getStopIndex(insertValuesSegments));
        for (InsertValueContext each : insertStatementContext.getInsertValueContexts()) {
            InsertValue insertValueToken = new InsertValue(each.getValueExpressions());
            this.encryptToken(insertValueToken, tableName, insertStatementContext, each);
            result.getInsertValues().add(insertValueToken);
        }
        return result;
    }

    private int getStartIndex(Collection<InsertValuesSegment> segments) {
        int result = segments.iterator().next().getStartIndex();
        for (InsertValuesSegment each : segments) {
            result = Math.min(result, each.getStartIndex());
        }
        return result;
    }

    private int getStopIndex(Collection<InsertValuesSegment> segments) {
        int result = segments.iterator().next().getStopIndex();
        for (InsertValuesSegment each : segments) {
            result = Math.max(result, each.getStopIndex());
        }
        return result;
    }

    private void encryptToken(InsertValue insertValueToken, String tableName, InsertStatementContext insertStatementContext, InsertValueContext insertValueContext) {
        Optional<SQLToken> useDefaultInsertColumnsToken = this.findPreviousSQLToken(UseDefaultInsertColumnsToken.class);
        Iterator descendingColumnNames = insertStatementContext.getDescendingColumnNames();
        while (descendingColumnNames.hasNext()) {
            String columnName = (String)descendingColumnNames.next();
            Optional encryptor = this.getEncryptRule().findEncryptor(tableName, columnName);
            if (!encryptor.isPresent()) continue;
            int columnIndex = useDefaultInsertColumnsToken.map(sqlToken -> ((UseDefaultInsertColumnsToken)sqlToken).getColumns().indexOf(columnName)).orElseGet(() -> insertStatementContext.getColumnNames().indexOf(columnName));
            Object originalValue = insertValueContext.getValue(columnIndex);
            this.addPlainColumn(insertValueToken, columnIndex, tableName, columnName, insertValueContext, originalValue);
            this.addAssistedQueryColumn(insertValueToken, (Encryptor)encryptor.get(), columnIndex, tableName, columnName, insertValueContext, originalValue);
            this.setCipherColumn(insertValueToken, (Encryptor)encryptor.get(), columnIndex, (ExpressionSegment)insertValueContext.getValueExpressions().get(columnIndex), originalValue);
        }
    }

    private void addPlainColumn(InsertValue insertValueToken, int columnIndex, String tableName, String columnName, InsertValueContext insertValueContext, Object originalValue) {
        if (this.getEncryptRule().findPlainColumn(tableName, columnName).isPresent()) {
            DerivedLiteralExpressionSegment derivedExpressionSegment = insertValueContext.getParameters().isEmpty() ? new DerivedLiteralExpressionSegment(originalValue) : new DerivedParameterMarkerExpressionSegment(this.getParameterIndexCount(insertValueToken));
            insertValueToken.getValues().add(columnIndex + 1, derivedExpressionSegment);
        }
    }

    private void addAssistedQueryColumn(InsertValue insertValueToken, Encryptor encryptor, int columnIndex, String tableName, String columnName, InsertValueContext insertValueContext, Object originalValue) {
        if (this.getEncryptRule().findAssistedQueryColumn(tableName, columnName).isPresent()) {
            DerivedLiteralExpressionSegment derivedExpressionSegment = insertValueContext.getParameters().isEmpty() ? new DerivedLiteralExpressionSegment((Object)((QueryAssistedEncryptor)encryptor).queryAssistedEncrypt(null == originalValue ? null : originalValue.toString())) : new DerivedParameterMarkerExpressionSegment(this.getParameterIndexCount(insertValueToken));
            insertValueToken.getValues().add(columnIndex + 1, derivedExpressionSegment);
        }
    }

    private int getParameterIndexCount(InsertValue insertValueToken) {
        int result = 0;
        for (ExpressionSegment each : insertValueToken.getValues()) {
            if (!(each instanceof ParameterMarkerExpressionSegment)) continue;
            ++result;
        }
        return result;
    }

    private void setCipherColumn(InsertValue insertValueToken, Encryptor encryptor, int columnIndex, ExpressionSegment valueExpression, Object originalValue) {
        if (valueExpression instanceof LiteralExpressionSegment) {
            insertValueToken.getValues().set(columnIndex, new LiteralExpressionSegment(valueExpression.getStartIndex(), valueExpression.getStopIndex(), (Object)encryptor.encrypt(originalValue)));
        }
    }

    @Generated
    public void setPreviousSQLTokens(List<SQLToken> previousSQLTokens) {
        this.previousSQLTokens = previousSQLTokens;
    }
}

