/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.BaseEncryptSQLTokenGenerator;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.column.InsertColumnsSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.underlying.rewrite.sql.token.pojo.generic.SubstitutableColumnNameToken;

public final class InsertCipherNameTokenGenerator
extends BaseEncryptSQLTokenGenerator
implements CollectionSQLTokenGenerator<InsertStatementContext> {
    @Override
    protected boolean isGenerateSQLTokenForEncrypt(SQLStatementContext sqlStatementContext) {
        if (!(sqlStatementContext instanceof InsertStatementContext)) {
            return false;
        }
        Optional insertColumnsSegment = ((InsertStatement)((InsertStatementContext)sqlStatementContext).getSqlStatement()).getInsertColumns();
        return insertColumnsSegment.isPresent() && !((InsertColumnsSegment)insertColumnsSegment.get()).getColumns().isEmpty();
    }

    public Collection<SubstitutableColumnNameToken> generateSQLTokens(InsertStatementContext insertStatementContext) {
        Optional sqlSegment = ((InsertStatement)insertStatementContext.getSqlStatement()).getInsertColumns();
        Preconditions.checkState((boolean)sqlSegment.isPresent());
        Map logicAndCipherColumns = this.getEncryptRule().getLogicAndCipherColumns(((InsertStatement)insertStatementContext.getSqlStatement()).getTable().getTableName().getIdentifier().getValue());
        LinkedList<SubstitutableColumnNameToken> result = new LinkedList<SubstitutableColumnNameToken>();
        for (ColumnSegment each : ((InsertColumnsSegment)sqlSegment.get()).getColumns()) {
            if (!logicAndCipherColumns.keySet().contains(each.getIdentifier().getValue())) continue;
            result.add(new SubstitutableColumnNameToken(each.getStartIndex(), each.getStopIndex(), (String)logicAndCipherColumns.get(each.getIdentifier().getValue())));
        }
        return result;
    }
}

