/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.core.metadata.database.datatype;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;

public final class DataTypeLoader {
    public Map<String, Integer> load(DatabaseMetaData databaseMetaData, DatabaseType databaseType) throws SQLException {
        Map<String, Integer> result = this.loadStandardDataTypes(databaseMetaData);
        result.putAll(new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData().getExtraDataTypes());
        return result;
    }

    private Map<String, Integer> loadStandardDataTypes(DatabaseMetaData databaseMetaData) throws SQLException {
        TreeMap<String, Integer> result = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
        try (ResultSet resultSet = databaseMetaData.getTypeInfo();){
            while (resultSet.next()) {
                result.put(resultSet.getString("TYPE_NAME"), resultSet.getInt("DATA_TYPE"));
            }
        }
        return result;
    }
}

