/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.core.resultset;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.shardingsphere.infra.database.core.resultset.DialectResultSetMapper;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;

public final class ResultSetMapper {
    private final DialectResultSetMapper dialectLoader;

    public ResultSetMapper(DatabaseType databaseType) {
        this.dialectLoader = DatabaseTypedSPILoader.findService(DialectResultSetMapper.class, databaseType).orElse(null);
    }

    public Object load(ResultSet resultSet, int columnIndex) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        switch (metaData.getColumnType(columnIndex)) {
            case 16: {
                return resultSet.getBoolean(columnIndex);
            }
            case -6: 
            case 5: {
                return null == this.dialectLoader ? Integer.valueOf(resultSet.getInt(columnIndex)) : this.dialectLoader.getSmallintValue(resultSet, columnIndex);
            }
            case 4: {
                if (metaData.isSigned(columnIndex)) {
                    return resultSet.getInt(columnIndex);
                }
                return resultSet.getLong(columnIndex);
            }
            case -5: {
                if (metaData.isSigned(columnIndex)) {
                    return resultSet.getLong(columnIndex);
                }
                BigDecimal bigDecimal = resultSet.getBigDecimal(columnIndex);
                return null == bigDecimal ? null : bigDecimal.toBigInteger();
            }
            case 2: 
            case 3: {
                return resultSet.getBigDecimal(columnIndex);
            }
            case 6: 
            case 8: {
                return resultSet.getDouble(columnIndex);
            }
            case -1: 
            case 1: 
            case 12: {
                return resultSet.getString(columnIndex);
            }
            case 91: {
                return null == this.dialectLoader ? resultSet.getDate(columnIndex) : this.dialectLoader.getDateValue(resultSet, columnIndex);
            }
            case 92: {
                return resultSet.getTime(columnIndex);
            }
            case 93: {
                return resultSet.getTimestamp(columnIndex);
            }
            case 2005: {
                return resultSet.getClob(columnIndex);
            }
            case 2004: {
                return resultSet.getBlob(columnIndex);
            }
            case -4: 
            case -3: 
            case -2: {
                return resultSet.getBytes(columnIndex);
            }
            case 2003: {
                return resultSet.getArray(columnIndex);
            }
        }
        return resultSet.getObject(columnIndex);
    }
}

