/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.core.spi;

import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPI;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.spi.exception.ServiceProviderNotFoundException;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

public final class DatabaseTypedSPILoader {
    public static <T extends DatabaseTypedSPI> Optional<T> findService(Class<T> spiClass, DatabaseType databaseType) {
        Optional result = TypedSPILoader.findService(spiClass, (Object)databaseType);
        if (result.isPresent()) {
            return result;
        }
        if (databaseType.getTrunkDatabaseType().isPresent()) {
            return TypedSPILoader.findService(spiClass, (Object)databaseType.getTrunkDatabaseType().get());
        }
        return result;
    }

    public static <T extends DatabaseTypedSPI> Optional<T> findService(Class<T> spiClass, DatabaseType databaseType, Properties props) {
        Optional result = TypedSPILoader.findService(spiClass, (Object)databaseType, (Properties)props);
        if (result.isPresent()) {
            return result;
        }
        if (databaseType.getTrunkDatabaseType().isPresent()) {
            return TypedSPILoader.findService(spiClass, (Object)databaseType.getTrunkDatabaseType().get(), (Properties)props);
        }
        return result;
    }

    public static <T extends DatabaseTypedSPI> T getService(Class<T> spiClass, DatabaseType databaseType) {
        return (T)((DatabaseTypedSPI)DatabaseTypedSPILoader.findService(spiClass, databaseType).orElseThrow(() -> new ServiceProviderNotFoundException(spiClass, (Object)databaseType.getType())));
    }

    public static <T extends DatabaseTypedSPI> T getService(Class<T> spiClass, DatabaseType databaseType, Properties props) {
        return (T)((DatabaseTypedSPI)DatabaseTypedSPILoader.findService(spiClass, databaseType, props).orElseThrow(() -> new ServiceProviderNotFoundException(spiClass, (Object)databaseType.getType())));
    }

    @Generated
    private DatabaseTypedSPILoader() {
    }
}

