/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.core.type;

import java.util.Collection;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.UnsupportedStorageTypeException;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;

public final class DatabaseTypeFactory {
    public static DatabaseType get(String url) {
        Collection databaseTypes = ShardingSphereServiceLoader.getServiceInstances(DatabaseType.class).stream().filter(each -> DatabaseTypeFactory.matchURLs(url, each)).collect(Collectors.toList());
        ShardingSpherePreconditions.checkState((!databaseTypes.isEmpty() ? 1 : 0) != 0, () -> new UnsupportedStorageTypeException(url));
        for (DatabaseType each2 : databaseTypes) {
            if (!each2.getTrunkDatabaseType().isPresent()) continue;
            return each2;
        }
        return (DatabaseType)databaseTypes.iterator().next();
    }

    private static boolean matchURLs(String url, DatabaseType databaseType) {
        return databaseType.getJdbcUrlPrefixes().stream().anyMatch(url::startsWith);
    }

    @Generated
    private DatabaseTypeFactory() {
    }
}

