/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import com.google.common.collect.Maps;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.shenyu.admin.listener.http.HttpLongPollingDataChangedListener;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.common.dto.ConfigData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ConditionalOnBean(value={HttpLongPollingDataChangedListener.class})
@RestController
@RequestMapping(value={"/configs"})
public class ConfigController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigController.class);
    @Resource
    private HttpLongPollingDataChangedListener longPollingListener;

    @GetMapping(value={"/fetch"})
    public ShenyuAdminResult fetchConfigs(@NotNull String[] groupKeys) {
        HashMap result = Maps.newHashMap();
        for (String groupKey : groupKeys) {
            ConfigData<?> data = this.longPollingListener.fetchConfig(ConfigGroupEnum.valueOf((String)groupKey));
            result.put(groupKey, data);
        }
        return ShenyuAdminResult.success("success", result);
    }

    @PostMapping(value={"/listener"})
    public void listener(HttpServletRequest request, HttpServletResponse response) {
        this.longPollingListener.doLongPolling(request, response);
    }
}

