/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.BatchCommonDTO;
import org.apache.shenyu.admin.model.dto.PluginDTO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageParameter;
import org.apache.shenyu.admin.model.query.PluginQuery;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.model.vo.PluginVO;
import org.apache.shenyu.admin.service.PluginService;
import org.apache.shenyu.admin.service.SyncDataService;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/plugin"})
public class PluginController {
    private final PluginService pluginService;
    private final SyncDataService syncDataService;

    @GetMapping(value={""})
    public ShenyuAdminResult queryPlugins(String name, Integer enabled, Integer currentPage, Integer pageSize) {
        CommonPager<PluginVO> commonPager = this.pluginService.listByPage(new PluginQuery(name, enabled, new PageParameter(currentPage, pageSize)));
        return ShenyuAdminResult.success("query success", commonPager);
    }

    @GetMapping(value={"/all"})
    public ShenyuAdminResult queryAllPlugins() {
        List<PluginData> pluginDataList = this.pluginService.listAll();
        return ShenyuAdminResult.success("query success", pluginDataList);
    }

    @GetMapping(value={"/{id}"})
    public ShenyuAdminResult detailPlugin(@PathVariable(value="id") String id) {
        PluginVO pluginVO = this.pluginService.findById(id);
        return ShenyuAdminResult.success("detail success", pluginVO);
    }

    @PostMapping(value={""})
    public ShenyuAdminResult createPlugin(@Valid @RequestBody PluginDTO pluginDTO) {
        String result = this.pluginService.createOrUpdate(pluginDTO);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{result})) {
            return ShenyuAdminResult.error(result);
        }
        return ShenyuAdminResult.success("create success");
    }

    @PutMapping(value={"/{id}"})
    public ShenyuAdminResult updatePlugin(@PathVariable(value="id") String id, @Valid @RequestBody PluginDTO pluginDTO) {
        pluginDTO.setId(id);
        String result = this.pluginService.createOrUpdate(pluginDTO);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{result})) {
            return ShenyuAdminResult.error(result);
        }
        return ShenyuAdminResult.success("update success");
    }

    @DeleteMapping(value={"/batch"})
    public ShenyuAdminResult deletePlugins(@RequestBody @NotEmpty List<@NotBlank String> ids) {
        String result = this.pluginService.delete(ids);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{result})) {
            return ShenyuAdminResult.error(result);
        }
        return ShenyuAdminResult.success("delete success");
    }

    @PostMapping(value={"/enabled"})
    public ShenyuAdminResult enabled(@Valid @RequestBody BatchCommonDTO batchCommonDTO) {
        String result = this.pluginService.enabled(batchCommonDTO.getIds(), batchCommonDTO.getEnabled());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{result})) {
            return ShenyuAdminResult.error(result);
        }
        return ShenyuAdminResult.success("enable success");
    }

    @PostMapping(value={"/syncPluginAll"})
    public ShenyuAdminResult syncPluginAll() {
        boolean success = this.syncDataService.syncAll(DataEventTypeEnum.REFRESH);
        if (success) {
            return ShenyuAdminResult.success("sync success");
        }
        return ShenyuAdminResult.error("sync fail");
    }

    @PutMapping(value={"/syncPluginData/{id}"})
    public ShenyuAdminResult syncPluginData(@PathVariable(value="id") String id) {
        boolean success = this.syncDataService.syncPluginData(id);
        if (success) {
            return ShenyuAdminResult.success("sync success");
        }
        return ShenyuAdminResult.error("sync fail");
    }

    @Generated
    public PluginController(PluginService pluginService, SyncDataService syncDataService) {
        this.pluginService = pluginService;
        this.syncDataService = syncDataService;
    }
}

