/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import lombok.Generated;
import org.apache.shenyu.admin.model.dto.PluginHandleDTO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageParameter;
import org.apache.shenyu.admin.model.query.PluginHandleQuery;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.model.vo.PluginHandleVO;
import org.apache.shenyu.admin.service.PluginHandleService;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/plugin-handle"})
public class PluginHandleController {
    private final PluginHandleService pluginHandleService;

    @GetMapping(value={""})
    public ShenyuAdminResult queryPluginHandles(String pluginId, String field, Integer currentPage, Integer pageSize) {
        CommonPager<PluginHandleVO> commonPager = this.pluginHandleService.listByPage(new PluginHandleQuery(pluginId, field, null, new PageParameter(currentPage, pageSize)));
        return ShenyuAdminResult.success("query success", commonPager);
    }

    @GetMapping(value={"/all/{pluginId}/{type}"})
    public ShenyuAdminResult queryAllPluginHandlesByPluginId(@PathVariable(value="pluginId") String pluginId, @PathVariable(value="type") Integer type) {
        List<PluginHandleVO> pluginHandleVOS = this.pluginHandleService.list(pluginId, type);
        return ShenyuAdminResult.success("query success", pluginHandleVOS);
    }

    @GetMapping(value={"/{id}"})
    public ShenyuAdminResult detailRule(@PathVariable(value="id") String id) {
        PluginHandleVO pluginHandleVO = this.pluginHandleService.findById(id);
        return ShenyuAdminResult.success("detail success", pluginHandleVO);
    }

    @PostMapping(value={""})
    public ShenyuAdminResult createPluginHandle(@Valid @RequestBody PluginHandleDTO pluginHandleDTO) {
        Integer createCount = this.pluginHandleService.createOrUpdate(pluginHandleDTO);
        return ShenyuAdminResult.success("create success", createCount);
    }

    @PutMapping(value={"/{id}"})
    public ShenyuAdminResult updatePluginHandle(@PathVariable(value="id") String id, @Valid @RequestBody PluginHandleDTO pluginHandleDTO) {
        pluginHandleDTO.setId(id);
        return ShenyuAdminResult.success("update success", this.pluginHandleService.createOrUpdate(pluginHandleDTO));
    }

    @DeleteMapping(value={"/batch"})
    public ShenyuAdminResult deletePluginHandles(@RequestBody @NotEmpty List<@NotBlank String> ids) {
        return ShenyuAdminResult.success("delete success", this.pluginHandleService.deletePluginHandles(ids));
    }

    @Generated
    public PluginHandleController(PluginHandleService pluginHandleService) {
        this.pluginHandleService = pluginHandleService;
    }
}

