/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import lombok.Generated;
import org.apache.shenyu.admin.model.dto.BatchCommonDTO;
import org.apache.shenyu.admin.model.dto.ShenyuDictDTO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageParameter;
import org.apache.shenyu.admin.model.query.ShenyuDictQuery;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.model.vo.ShenyuDictVO;
import org.apache.shenyu.admin.service.ShenyuDictService;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/shenyu-dict"})
public class ShenyuDictController {
    private final ShenyuDictService shenyuDictService;

    @GetMapping(value={""})
    public ShenyuAdminResult queryDicts(String type, String dictCode, String dictName, Integer currentPage, Integer pageSize) {
        CommonPager<ShenyuDictVO> commonPager = this.shenyuDictService.listByPage(new ShenyuDictQuery(type, dictCode, dictName, new PageParameter(currentPage, pageSize)));
        return ShenyuAdminResult.success("query success", commonPager);
    }

    @GetMapping(value={"/all/{type}"})
    public ShenyuAdminResult findByType(@PathVariable(value="type") String type) {
        List<ShenyuDictVO> shenyuDictVOS = this.shenyuDictService.list(type);
        return ShenyuAdminResult.success("query success", shenyuDictVOS);
    }

    @GetMapping(value={"/{id}"})
    public ShenyuAdminResult detail(@PathVariable(value="id") String id) {
        ShenyuDictVO shenyuDictVO = this.shenyuDictService.findById(id);
        return ShenyuAdminResult.success("detail success", shenyuDictVO);
    }

    @PostMapping(value={""})
    public ShenyuAdminResult createShenyuDict(@Valid @RequestBody ShenyuDictDTO shenyuDictDTO) {
        Integer createCount = this.shenyuDictService.createOrUpdate(shenyuDictDTO);
        return ShenyuAdminResult.success("create success", createCount);
    }

    @PutMapping(value={"/{id}"})
    public ShenyuAdminResult updateShenyuDict(@PathVariable(value="id") String id, @Valid @RequestBody ShenyuDictDTO shenyuDictDTO) {
        Objects.requireNonNull(shenyuDictDTO);
        shenyuDictDTO.setId(id);
        Integer updateCount = this.shenyuDictService.createOrUpdate(shenyuDictDTO);
        return ShenyuAdminResult.success("update success", updateCount);
    }

    @DeleteMapping(value={"/batch"})
    public ShenyuAdminResult deleteShenyuDicts(@RequestBody @NotEmpty List<@NotBlank String> ids) {
        Integer deleteCount = this.shenyuDictService.deleteShenyuDicts(ids);
        return ShenyuAdminResult.success("delete success", deleteCount);
    }

    @PostMapping(value={"/batchEnabled"})
    public ShenyuAdminResult batchEnabled(@Valid @RequestBody BatchCommonDTO batchCommonDTO) {
        Integer result = this.shenyuDictService.enabled(batchCommonDTO.getIds(), batchCommonDTO.getEnabled());
        return ShenyuAdminResult.success("batch enable success", result);
    }

    @Generated
    public ShenyuDictController(ShenyuDictService shenyuDictService) {
        this.shenyuDictService = shenyuDictService;
    }
}

