/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import java.util.Collections;
import org.apache.shenyu.register.common.config.ShenyuRegisterCenterConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.server.api.ShenyuServerRegisterPublisher;
import org.apache.shenyu.register.server.api.ShenyuServerRegisterRepository;
import org.apache.shenyu.spi.Join;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/shenyu-client"})
@Join
public class ShenyuHttpRegistryController
implements ShenyuServerRegisterRepository {
    private ShenyuServerRegisterPublisher publisher;

    public void init(ShenyuServerRegisterPublisher publisher, ShenyuRegisterCenterConfig config) {
        this.init(config);
        this.publisher = publisher;
    }

    @PostMapping(value={"/springmvc-register"})
    @ResponseBody
    public String registerSpringMvc(@RequestBody MetaDataRegisterDTO metaDataRegisterDTO) {
        this.publish(metaDataRegisterDTO);
        return "success";
    }

    @PostMapping(value={"/springcloud-register"})
    @ResponseBody
    public String registerSpringCloud(@RequestBody MetaDataRegisterDTO metaDataRegisterDTO) {
        this.publish(metaDataRegisterDTO);
        return "success";
    }

    @PostMapping(value={"/dubbo-register"})
    @ResponseBody
    public String registerRpc(@RequestBody MetaDataRegisterDTO metaDataRegisterDTO) {
        this.publish(metaDataRegisterDTO);
        return "success";
    }

    @PostMapping(value={"/sofa-register"})
    @ResponseBody
    public String registerSofaRpc(@RequestBody MetaDataRegisterDTO metaDataRegisterDTO) {
        this.publish(metaDataRegisterDTO);
        return "success";
    }

    @PostMapping(value={"/tars-register"})
    @ResponseBody
    public String registerTarsRpc(@RequestBody MetaDataRegisterDTO metaDataRegisterDTO) {
        this.publish(metaDataRegisterDTO);
        return "success";
    }

    @PostMapping(value={"/grpc-register"})
    @ResponseBody
    public String registerGrpc(@RequestBody MetaDataRegisterDTO metaDataRegisterDTO) {
        this.publish(metaDataRegisterDTO);
        return "success";
    }

    @PostMapping(value={"/motan-register"})
    @ResponseBody
    public String registerMotan(@RequestBody MetaDataRegisterDTO metaDataRegisterDTO) {
        this.publish(metaDataRegisterDTO);
        return "success";
    }

    private void publish(MetaDataRegisterDTO metaDataRegisterDTO) {
        this.publisher.publish(Collections.singletonList(metaDataRegisterDTO));
    }
}

