/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.disruptor.subscriber;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shenyu.admin.service.register.ShenyuClientRegisterServiceFactory;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.subsriber.ExecutorTypeSubscriber;
import org.apache.shenyu.register.common.type.DataType;

public class URIRegisterExecutorSubscriber
implements ExecutorTypeSubscriber<URIRegisterDTO> {
    private final Map<String, ShenyuClientRegisterServiceFactory> shenyuClientRegisterService;

    public URIRegisterExecutorSubscriber(Map<String, ShenyuClientRegisterServiceFactory> shenyuClientRegisterService) {
        this.shenyuClientRegisterService = shenyuClientRegisterService;
    }

    public DataType getType() {
        return DataType.URI;
    }

    public void executor(Collection<URIRegisterDTO> dataList) {
        Map<String, List<URIRegisterDTO>> listMap = dataList.stream().collect(Collectors.groupingBy(URIRegisterDTO::getContextPath));
        listMap.forEach((contextPath, dtoList) -> {
            ArrayList<String> uriList = new ArrayList<String>();
            dataList.forEach(uriRegisterDTO -> {
                if (uriRegisterDTO.getHost() != null && uriRegisterDTO.getPort() != null) {
                    uriList.add(String.join((CharSequence)":", uriRegisterDTO.getHost(), uriRegisterDTO.getPort().toString()));
                }
            });
            this.shenyuClientRegisterService.get("default").registerURI((String)contextPath, (List<String>)uriList);
        });
    }
}

