/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.exception;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolationException;
import lombok.Generated;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shiro.authz.UnauthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.validation.BindingResult;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@ResponseBody
@ControllerAdvice
public class ExceptionHandlers {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExceptionHandlers.class);

    @ExceptionHandler(value={Exception.class})
    protected ShenyuAdminResult serverExceptionHandler(Exception exception) {
        String message;
        log.error(exception.getMessage(), (Throwable)exception);
        if (exception instanceof ShenyuException) {
            ShenyuException shenyuException = (ShenyuException)exception;
            message = shenyuException.getMessage();
        } else {
            message = "The system is busy, please try again later";
        }
        return ShenyuAdminResult.error(message);
    }

    @ExceptionHandler(value={DuplicateKeyException.class})
    protected ShenyuAdminResult serverExceptionHandler(DuplicateKeyException exception) {
        log.error(exception.getMessage(), (Throwable)exception);
        return ShenyuAdminResult.error("unique index conflict, please enter again");
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    protected ShenyuAdminResult shiroExceptionHandler(UnauthorizedException exception) {
        log.error(exception.getMessage(), (Throwable)exception);
        return ShenyuAdminResult.error(601, "toke has no permission");
    }

    @ExceptionHandler(value={NullPointerException.class})
    protected ShenyuAdminResult nullPointExceptionHandler(NullPointerException exception) {
        log.error(exception.getMessage(), (Throwable)exception);
        return ShenyuAdminResult.error(404, "not found exception");
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    protected ShenyuAdminResult handleHttpRequestMethodNotSupportedException(HttpRequestMethodNotSupportedException e) {
        log.warn("", (Throwable)e);
        StringBuilder sb = new StringBuilder();
        sb.append(e.getMethod());
        sb.append(" method is not supported for this request. Supported methods are ");
        e.getSupportedHttpMethods().forEach(t -> sb.append(t + " "));
        return ShenyuAdminResult.error(sb.toString());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    protected ShenyuAdminResult handleMethodArgumentNotValidException(MethodArgumentNotValidException e) {
        log.warn("", (Throwable)e);
        BindingResult bindingResult = e.getBindingResult();
        String errorMsg = bindingResult.getFieldErrors().stream().map(f -> f.getField().concat(": ").concat(Optional.ofNullable(f.getDefaultMessage()).orElse(""))).collect(Collectors.joining("| "));
        return ShenyuAdminResult.error(String.format("Request error! invalid argument [%s]", errorMsg));
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    protected ShenyuAdminResult handleMissingServletRequestParameterException(MissingServletRequestParameterException e) {
        log.warn("", (Throwable)e);
        return ShenyuAdminResult.error(String.format("%s parameter is missing", e.getParameterName()));
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    protected ShenyuAdminResult handleMethodArgumentTypeMismatchException(MethodArgumentTypeMismatchException e) {
        log.warn("", (Throwable)e);
        return ShenyuAdminResult.error(String.format("%s should be of type %s", e.getName(), e.getRequiredType().getName()));
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    protected ShenyuAdminResult handleConstraintViolationException(ConstraintViolationException e) {
        log.warn("", (Throwable)e);
        Set violations = e.getConstraintViolations();
        return ShenyuAdminResult.error(violations.stream().map(v -> v.getPropertyPath().toString().concat(": ").concat(v.getMessage())).collect(Collectors.joining("| ")));
    }
}

