/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.listener.etcd;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.options.DeleteOption;
import io.etcd.jetcd.options.GetOption;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EtcdClient.class);
    private final Client client;

    public EtcdClient(Client client) {
        this.client = client;
    }

    public void close() {
        this.client.close();
    }

    public Boolean exists(String key) {
        GetOption option = GetOption.newBuilder().withPrefix(ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8)).build();
        List keyValues = ((GetResponse)this.client.getKVClient().get(ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8), option).get()).getKvs();
        return !keyValues.isEmpty();
    }

    public void put(String key, String value) {
        this.client.getKVClient().put(ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8), ByteSequence.from((String)value, (Charset)StandardCharsets.UTF_8)).get();
    }

    public void delete(String key) {
        this.client.getKVClient().delete(ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8));
    }

    public void deleteEtcdPathRecursive(String path) {
        DeleteOption option = DeleteOption.newBuilder().withPrefix(ByteSequence.from((String)path, (Charset)StandardCharsets.UTF_8)).build();
        this.client.getKVClient().delete(ByteSequence.from((String)path, (Charset)StandardCharsets.UTF_8), option);
    }
}

