/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.listener.nacos;

import com.alibaba.nacos.api.config.ConfigService;
import org.apache.shenyu.admin.service.SyncDataService;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.springframework.boot.CommandLineRunner;

public class NacosDataInit
implements CommandLineRunner {
    private final ConfigService configService;
    private final SyncDataService syncDataService;

    public NacosDataInit(ConfigService configService, SyncDataService syncDataService) {
        this.configService = configService;
        this.syncDataService = syncDataService;
    }

    public void run(String ... args) {
        String pluginDataId = "shenyu.plugin.json";
        String authDataId = "shenyu.auth.json";
        String metaDataId = "shenyu.meta.json";
        if (this.dataIdNotExist(pluginDataId) && this.dataIdNotExist(authDataId) && this.dataIdNotExist(metaDataId)) {
            this.syncDataService.syncAll(DataEventTypeEnum.REFRESH);
        }
    }

    private boolean dataIdNotExist(String pluginDataId) {
        String group = "DEFAULT_GROUP";
        long timeout = 6000L;
        return this.configService.getConfig(pluginDataId, group, timeout) == null;
    }
}

